<?php
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/', array(
    'uses' => 'Vendor\VendorController@login', 'middleware' => 'PreventBackHistory',
    'as' => 'vendorLogin',
));
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'logout', array(
    'uses' => 'Vendor\VendorController@logout',
    'as' => 'logout',
));
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'dashboard', array(
    'uses' => 'Vendor\VendorController@dashboard',
));

Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'notification', array(
    'uses' => 'Vendor\NotificationController@index',
));

// Route::match(array('GET', 'POST', 'PUT', 'PATCH') , 'menu/statusHandler' ,
// array('uses'=>'Vendor\RestaurantMenuController@statusHandler'));

Route::resource('menu', 'Vendor\RestaurantMenuController');
Route::resource('transaction', 'Vendor\TransactionController');
Route::resource('profile', 'Vendor\ProfileController');
Route::post('profile/change-email', 'Vendor\ProfileController@validateEmail');
Route::post('profile/validate-current-password', 'Vendor\ProfileController@validateCurrentPassword');
Route::post('profile/verify-otp', 'Vendor\ProfileController@verifyOtp');

Route::post('profile/change-phone-number', 'Vendor\ProfileController@validatePhoneNumber');
Route::post('profile/verify-sms-otp', 'Vendor\ProfileController@verifyOtpForNumber');
Route::post('profile/resend-sms-otp', 'Vendor\ProfileController@sendSmsOtp');
Route::post('profile/resend-otp', 'Vendor\ProfileController@resendEmailChangeOtp');


// change password after login //
Route::get('profile-change-password', 'Vendor\ProfileController@changePassword');
Route::put('vendor-update-password', 'Vendor\ProfileController@updatePassword');


Route::get('vendor-terms-of-services', 'Vendor\TermsofservicesController@index');
Route::get('vendor-privacy-policy', 'Vendor\TermsofservicesController@privacyPolicy');
Route::resource('contact-us', 'Vendor\ContactUsController');

Route::resource('order', 'Vendor\OrderController');
Route::get('order/approve/{id}', 'Vendor\OrderController@approve');
Route::get('order/reject/{id}', 'Vendor\OrderController@reject');
Route::get('order/handover/{id}', 'Vendor\OrderController@outForDelivery');
Route::get('order/cancel/{id}', 'Vendor\OrderController@cancel');
Route::get('order/re-assign-rider/{id}', 'Vendor\OrderController@reAssignRider');
Route::get('test', 'Vendor\OrderController@test');

Route::get('dashboard/online-offline-restaurant', 'Vendor\VendorController@rstOnOffLine');
