<?php

/**
 * Author: NMG
 * Description: Api routes using passport auth api middleware
 * Dated: 17/July/2021
 */

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('register', 'Api\V1\AuthController@register');
Route::post('verifyAccount', 'Api\V1\AuthController@verifyOtp');
Route::post('login', 'Api\V1\AuthController@login');
Route::post('forgot_password', 'Api\V1\UserController@forgotPassword');
Route::post('reset_password', 'Api\V1\UserController@resetPassword');
Route::get('staticpages/{slug}', 'Api\V1\StaticPagesController@show');
Route::get('force-update-status', 'Api\V1\ForceUpdateController@forceUpdate');
// Route::post('refreshToken', 'Api\v1\AuthController@refreshToken');
// Route::get('test_push_notification/{user_id?}', 'Api\V1\BaseController@testPushNotification');
Route::get('test_push_notification', 'Api\V1\CartController@testNotification');


// Route::post('send_otp', 'Api\v1\UserController@sendOtp');
// // Route::post('verify_otp', 'Api\v1\UserController@verifyOtp'); // old
// Route::post('verify_otp', 'Api\v1\AuthController@verifyOtp');
// Route::post('verify_email', 'Api\v1\AuthController@verifyEmail');
// Route::post('verify_mobile', 'Api\v1\AuthController@verifyMobile'); category_fav

Route::get('restaurant_list', 'Api\V1\RestaurantController@restaurantList');
Route::post('restaurant_details', 'Api\V1\RestaurantMenuController@index');


Route::group(['middleware' => 'auth:api'], function () {
    Route::post('contact-us', 'Api\V1\ContactSupportController@store');
    Route::apiResource('user-address', 'Api\V1\AddressController');
    Route::post('update_profile', 'Api\V1\UserController@editProfile');
    // Route::post('details', 'Api\v1\AuthController@details');
    Route::post('logout', 'Api\V1\AuthController@logout');
    Route::post('change_password', 'Api\V1\UserController@changePassword');
    Route::get('profile/{id?}', 'Api\V1\UserController@show');
    Route::put('profile/deactivate', 'Api\V1\UserController@deactivate');
    Route::get('notifications', 'Api\V1\NotificationController@index');
    Route::put('notifications/read', 'Api\V1\NotificationController@markRead');
    // Route::post('upload_avatar', 'Api\v1\UserController@changeAvatar');
    // Route::post('upload_media', 'Api\v1\UserController@uploadVideo');
    Route::post('change_mobile', 'Api\V1\UserController@changeMobile');
    Route::post('update_mobile', 'Api\V1\UserController@updateMobile');
    Route::put('toggle-notification', 'Api\V1\UserController@toggleNotification');
    Route::post('verify-password', 'Api\V1\UserController@verifyPassword');
    Route::post('change-email', 'Api\V1\UserController@changeEmail');
    Route::post('validate-email', 'Api\V1\UserController@validateEmail');

  //  Route::get('restaurant_list', 'Api\V1\RestaurantController@restaurantList');
  //  Route::post('restaurant_details', 'Api\V1\RestaurantMenuController@index');
    Route::apiResource('cart', 'Api\V1\CartController');

    Route::post('apply-rider', 'Api\V1\RiderController@applyRider');
    Route::put('toggle-rider-status', 'Api\V1\RiderController@toggleRiderStatus');

    Route::put('rider/location', 'Api\V1\RiderController@updateCurrentLocation');
    Route::get('rider/orders', 'Api\V1\RiderController@orders');
    Route::get('rider/order-details', 'Api\V1\RiderController@orderDetails');
    Route::post('rider/order/accept', 'Api\V1\RiderController@acceptOrderAssignment');
    Route::post('rider/order/reject', 'Api\V1\RiderController@rejectOrderAssignment');
    Route::post('rider/order/complete', 'Api\V1\RiderController@completeOrder');
    Route::get('rider/earning', 'Api\V1\RiderController@getEarningSummary');



    Route::post('cart/address', 'Api\V1\CartController@updateAddress');
    Route::post('cart/checkout', 'Api\V1\CartController@checkout');
    // order routes
    Route::post('order', 'Api\V1\OrderController@index');
    Route::get('order/details/{id}', 'Api\V1\OrderController@details');
    Route::post('order/cancel', 'Api\V1\OrderController@cancel');
});
