<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::match(array('GET', 'POST', 'PUT', 'PATCH'), 'forgot-password', array(
    'uses' => 'Admin\AdminController@forgotPassword',
    'as' => 'forgotPassword',
));
Route::match(array('GET', 'POST', 'PUT', 'PATCH'), '/reset-password/{token?}', array(
    'uses' => 'Admin\AdminController@resetPassword',
    'as' => 'ResetPassword',
));

Route::group(['middleware' => ['auth.admin']], function () {
    $dir = __DIR__ . "/route-base";
    if (is_dir($dir)) {
        if ($dh = opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if (strlen($file) > 5) {
                    include_once('route-base/' . $file);
                }
            }
            closedir($dh);
        }
    }
});

Route::get('/foo', function () {
    $exitCode = Artisan::call('email:send', [
        'emailSlug' => 'broadcast_email',
    ]);
});


Route::resource('mailbox', 'Admin\MailboxController');
Route::resource('notification', 'Admin\NotificationController');
Route::match(array('GET', 'POST', 'PUT', 'PATCH', 'AJAX'), 'mailboxsend', array(
    'uses' => 'Admin\MailboxController@store',
    'as' => 'mailboxsend',
));
Route::match(array('POST'), '/mailbox-image-upload', array(
    'uses' => 'Admin\MailboxController@uploadEditorImage',
));
