<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

        {!! Html::style(asset('/public/css/front/style.css')) !!}
        {!! Html::style(asset('/public/css/front/responsive.css')) !!}
    </head>

    <body>
        @if($slug == 'about-us')
            @if(isset($dynamicContents['About Us']))
                <div class="about-section page-section" id="about-us">
                    <div class="container">
                        <div class="lft">
                            @if(!empty($dynamicContents['About Us']['section_1']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['About Us']['section_1']['image']))
                                {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['About Us']['section_1']['image']), 'image') }}
                            @endif
                        </div>

                        <div class="rgt">
                            @if(!empty($dynamicContents['About Us']['section_1']['heading']))
                                <h2 class="section-heading">
                                    <span>{{ $dynamicContents['About Us']['section_1']['heading'] }}</span>
                                </h2>
                            @endif

                            @if(!empty($dynamicContents['About Us']['section_1']['content']))
                                <p>{{ $dynamicContents['About Us']['section_1']['content'] }}</p>
                            @endif
                        </div>

                        <div class="clearfix"></div>

                        <div class="product">
                            <ul>
                                <li>
                                    <div class="icon-box">
                                        @if(!empty($dynamicContents['About Us']['section_2']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['About Us']['section_2']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['About Us']['section_2']['image']), 'image') }}
                                        @endif
                                    </div>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['About Us']['section_2']['heading']))
                                            <span class="product-name">{{ $dynamicContents['About Us']['section_2']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['About Us']['section_2']['content']))
                                            <p>{{ $dynamicContents['About Us']['section_2']['content'] }}</p>
                                        @endif
                                    </div>
                                </li>

                                <li>
                                    <div class="icon-box">
                                        @if(!empty($dynamicContents['About Us']['section_3']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['About Us']['section_3']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['About Us']['section_3']['image']), 'image') }}
                                        @endif
                                    </div>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['About Us']['section_3']['heading']))
                                            <span class="product-name">{{ $dynamicContents['About Us']['section_3']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['About Us']['section_3']['content']))
                                            <p>{{ $dynamicContents['About Us']['section_3']['content'] }}</p>
                                        @endif
                                    </div>
                                </li>

                                <li>
                                    <div class="icon-box">
                                        @if(!empty($dynamicContents['About Us']['section_4']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['About Us']['section_4']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['About Us']['section_4']['image']), 'image') }}
                                        @endif
                                    </div>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['About Us']['section_4']['heading']))
                                            <span class="product-name">{{ $dynamicContents['About Us']['section_4']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['About Us']['section_4']['content']))
                                            <p>{{ $dynamicContents['About Us']['section_4']['content'] }}</p>
                                        @endif
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endif
        @elseif($slug == 'how-it-works')
            @if(isset($dynamicContents['How It Works']))
                <div class="how-It-section white-bg page-section" id="how-it-works">
                    <div class="container">
                        <h2 class="section-heading text-center">
                            <span>How It Works</span>
                        </h2>

                        <div class="clearfix"></div>

                        <div>
                            <div class="work-step margin-rgt">
                                <div class="step-box rgt">
                                    <div class="step-circle">
                                        <strong>01</strong>
                                        <small class="text-uppercase">Step</small>
                                    </div>
                                </div>

                                <div class="description lft">
                                    <figure>
                                        @if(!empty($dynamicContents['How It Works']['section_1']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['How It Works']['section_1']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['How It Works']['section_1']['image']), 'image') }}
                                        @endif
                                    </figure>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['How It Works']['section_1']['heading']))
                                            <span>{{ $dynamicContents['How It Works']['section_1']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['How It Works']['section_1']['content']))
                                            <p>{{ $dynamicContents['How It Works']['section_1']['content'] }}</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                            </div>

                            <div class="work-step margin-lft">
                                <div class="step-box lft">
                                    <div class="step-circle">
                                        <strong>02</strong>
                                        <small class="text-uppercase">Step</small>
                                    </div>
                                </div>

                                <div class="description rgt">
                                    <figure>
                                        @if(!empty($dynamicContents['How It Works']['section_2']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['How It Works']['section_2']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['How It Works']['section_2']['image']), 'image') }}
                                        @endif
                                    </figure>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['How It Works']['section_2']['heading']))
                                            <span>{{ $dynamicContents['How It Works']['section_2']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['How It Works']['section_2']['content']))
                                            <p>{{ $dynamicContents['How It Works']['section_2']['content'] }}</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                            </div>

                            <div class="work-step margin-rgt">
                                <div class="step-box rgt">
                                    <div class="step-circle">
                                        <strong>03</strong>
                                        <small class="text-uppercase">Step</small>
                                    </div>
                                </div>

                                <div class="description lft">
                                    <figure>
                                        @if(!empty($dynamicContents['How It Works']['section_3']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['How It Works']['section_3']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['How It Works']['section_3']['image']), 'image') }}
                                        @endif
                                    </figure>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['How It Works']['section_3']['heading']))
                                            <span>{{ $dynamicContents['How It Works']['section_3']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['How It Works']['section_3']['content']))
                                            <p>{{ $dynamicContents['How It Works']['section_3']['content'] }}</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                            </div>

                            <div class="work-step margin-lft">
                                <div class="step-box lft">
                                    <div class="step-circle">
                                        <strong>04</strong>
                                        <small class="text-uppercase">Step</small>
                                    </div>
                                </div>

                                <div class="description rgt">
                                    <figure>
                                        @if(!empty($dynamicContents['How It Works']['section_4']['image']) && Storage::disk('public')->has('dynamic_contents/' . $dynamicContents['How It Works']['section_4']['image']))
                                            {{ Html::image(Storage::url('app/public/dynamic_contents/' . $dynamicContents['How It Works']['section_4']['image']), 'image') }}
                                        @endif
                                    </figure>

                                    <div class="cnt">
                                        @if(!empty($dynamicContents['How It Works']['section_4']['heading']))
                                            <span>{{ $dynamicContents['How It Works']['section_4']['heading'] }}</span>
                                        @endif

                                        @if(!empty($dynamicContents['How It Works']['section_4']['content']))
                                            <p>{{ $dynamicContents['How It Works']['section_4']['content'] }}</p>
                                        @endif
                                    </div>
                                </div>

                                <div class="clearfix"></div>
                            </div>
                        </div>

                        <div class="clearfix"></div>
                    </div>
                </div>
            @endif
        @elseif($slug == 'faqs')
            @if(count($faqs))
                <div class="faq-section white-bg page-section" id="faqs">
                    <div class="container">
                        <h2 class="section-heading text-center">
                            <span>FAQs</span>
                        </h2>

                        <div id="accordion" class="accordion-container">
                            @foreach($faqs as $faq)
                                <article class="content-entry">
                                    <h4 class="article-title">{{ !empty($faq->question) ? $faq->question : config('constants.EmptyNotation') }}</h4>
                                    <div class="accordion-content">
                                        <p>{{ !empty($faq->answer) ? $faq->answer : config('constants.EmptyNotation') }}</p>
                                    </div>
                                </article>
                            @endforeach
                        </div>
                    </div>
                </div>

                {!! Html::script(asset('/public/js/jquery-2.1.4.min.js')) !!}

                <script type="text/javascript">
                    //Accordion
                    var Accordion = function(el, multiple) {
                                        this.el = el || {};
                                        this.multiple = multiple || false;
                                        var links = this.el.find('.article-title');

                                        links.on('click', {
                                            el: this.el,
                                            multiple: this.multiple
                                        }, this.dropdown)
                                    }

                    Accordion.prototype.dropdown = function(e) {
                                                        var $el = e.data.el;

                                                        $this = $(this),
                                                        $next = $this.next();

                                                        $next.slideToggle();
                                                        $this.parent().toggleClass('open');

                                                        if (!e.data.multiple) {
                                                            $el.find('.accordion-content').not($next).slideUp().parent().removeClass('open');
                                                        };
                                                    }

                    var accordion = new Accordion($('.accordion-container'), false);
                </script>
            @endif
        @else
            <div class="container">
                <div class="cms-page">
                    <h1 class="page-heading padding-top-0">{{ !empty($htmlTitle) ? $htmlTitle : '' }}</h1>

                    {!! !empty($cmsPage->description) ? $cmsPage->description : '' !!}
                </div>
            </div>
        @endif
    </body>
</html>
