@php
$uri = explode('/', Request::route()->uri());
$method = '';
if ($uri[1]) {
    $method = $uri[1];
    // print_r($method);
}
@endphp
<div id="mySidenav" class="sidenav">
    <div class="logo">
        <a href="{{ env('VENDOR_URL') . '/dashboard' }}">
            <img src="{{ asset('resources/assets/vendor/images/logo.png') }}" alt="Logo" title="">
        </a>
    </div>
    <ul>
        <li>
            <a href="{{ url('/' . config('admin.constants.RESTAURANT_ROUTE_NAME') . '/dashboard') }}"
                class="{{ $method == 'dashboard' ? 'active' : '' }}">
                <span class="menu-icon"><i class="dashboard"></i></span>
                <span class="menu-title">Dashboard</span>
            </a>
        </li>
        <li>
            <a href="{{ url('/' . config('admin.constants.RESTAURANT_ROUTE_NAME') . '/order') }}"
                class="{{ $method == 'order' ? 'active' : '' }}">
                <span class="menu-icon"><i class="order"></i></span>
                <span class="menu-title">My Orders</span>
            </a>
        </li>
        <li>
            <a href="{{ url('/' . config('admin.constants.RESTAURANT_ROUTE_NAME') . '/menu') }}"
                class="{{ $method == 'menu' ? 'active' : '' }}">
                <span class="menu-icon"><i class="manage"></i></span>
                <span class="menu-title">Manage Menu</span>
            </a>
        </li>

        <li>
            <a href="{{ url('/' . config('admin.constants.RESTAURANT_ROUTE_NAME') . '/transaction') }}"
                class="{{ $method == 'transaction' ? 'active' : '' }}">
                <span class="menu-icon"><i class="manage"></i></span>
                <span class="menu-title">Manage Transactions</span>
            </a>
        </li>
        <li class="{{ in_array($method, ['profile', 'profile-change-password']) ? 'selected' : '' }}">
            <a href="javascript:void(0)"
                class="arrow {{ in_array($method, ['profile', 'profile-change-password']) ? 'active' : '' }}">
                <span class="menu-icon"><i class="account"></i></span>
                <span class="menu-title">My Account</span>
            </a>
            <ul class="submenu"
                style="{{ in_array($method, ['profile', 'profile-change-password']) ? 'display:block;' : '' }}">
                <li>
                    <a href="{{ url('/' . config('admin.constants.RESTAURANT_ROUTE_NAME') . '/profile') }}"
                        class="{{ $method == 'profile' ? 'active' : '' }}">Restaurant
                        Profile</a>
                </li>
                <li>
                    <a href="{{ env('VENDOR_URL') . '/profile-change-password' }}"
                        class="{{ $method == 'profile-change-password' ? 'active' : '' }}">Change Password</a>
                </li>
            </ul>
        </li>
        <li>
            <a href="{{ env('VENDOR_URL') . '/contact-us' }}"
                class="{{ $method == 'contact-us' ? 'active' : '' }}">
                <span class="menu-icon"><i class="contact"></i></span>
                <span class="menu-title">Contact Us</span>
            </a>
        </li>
    </ul>
    <div class="footer">
        <div class="cnt">
            <span>Bring Me Food</span>
            <p>Copyright &#169; 2021, All rights reserved.</p>
            <div class="menu">

                @if (Request::segment(2) == 'vendor-privacy-policy')
                    <a href="{{ env('VENDOR_URL') . '/vendor-privacy-policy' }}" class="active">Privacy
                        Policy</a>
                    <a href="{{ env('VENDOR_URL') . '/vendor-terms-of-services' }}">Terms of Service</a>
                @elseif(Request::segment(2) == 'vendor-terms-of-services')
                    <a href="{{ env('VENDOR_URL') . '/vendor-privacy-policy' }}">Privacy Policy</a>
                    <a href="{{ env('VENDOR_URL') . '/vendor-terms-of-services' }}" class="active">Terms of
                        Service</a>
                @else
                    <a href="{{ env('VENDOR_URL') . '/vendor-privacy-policy' }}">Privacy Policy</a>
                    <a href="{{ env('VENDOR_URL') . '/vendor-terms-of-services' }}">Terms of Service</a>
                @endif
            </div>
        </div>
    </div>
</div><!-- sidenav  End -->
