<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"> 
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ ucwords(config('app.name', 'Laravel')) }} | {{$title}} - {{$subTitle}}</title>
    <link rel="icon" type="image/png" href="{{ asset('resources/assets/vendor/images/logo.png') }}">
    <!-- Custom styling -->
    <link href="{{ asset('resources/assets/vendor/css/bootstrap.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('resources/assets/vendor/css/style.css') }}"/>
    <link rel="stylesheet" href="{{ asset('resources/assets/vendor/css/responsive.css') }}"/>
    <link rel="stylesheet" href="{{ asset('resources/assets/vendor/css/fonts.css') }}"/>
    <script src="{{ asset('resources/assets/vendor/js/jquery.min.js') }}"></script> 
</head>
<body>
    <main class="wrapper">
       @yield('content')
    </main><!-- wrapper End -->

    
    <script src="{{ asset('resources/assets/vendor/js/bootstrap.min.js') }}"></script>  

    <script defer src="{{ asset('resources/assets/plugins/iCheck/icheck.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/jquery-validate/jquery.validate.js') }}"></script>
    
    <!-- js message objects to access by validation plugin -->
    @include('elements.Admin.lang.validation.user')

    <script defer src="{{ asset('resources/assets/js/validation/user.js') }}"></script>

    <script type="text/javascript">
        
        //Form Section show Password
        $(".toggle-password").click(function() {
            $(this).toggleClass("show-eye hide-eye");
            var input = $($(this).attr("toggle"));
            if ($('#password').attr('type') == "password") {
                $('#password').attr("type", "text");
            } else {
                $('#password').attr("type", "password");
            }
        });

        $(".toggle-password-new").click(function() {
            $(this).toggleClass("show-eye hide-eye");
            var input = $($(this).attr("toggle"));
            if ($('#new_password').attr('type') == "password") {
                $('#new_password').attr("type", "text");
            } else {
                $('#new_password').attr("type", "password");
            }
        });

        $(".toggle-password-conf").click(function() {
            $(this).toggleClass("show-eye hide-eye");
            var input = $($(this).attr("toggle"));
            if ($('#new_password_confirmation').attr('type') == "password") {
                $('#new_password_confirmation').attr("type", "text");
            } else {
                $('#new_password_confirmation').attr("type", "password");
            }
        });
    </script>
</body>
</html>