<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ ucwords(config('app.name', 'Laravel')) }} | {{$title}} - {{$subTitle}}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <link rel="stylesheet" href="{{ asset('resources/assets/css/jquery.fancybox.css?v=2.1.5') }}">
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    
    <!-- load admin css -->
    @if(env('APP_ENV') == 'local')
    <link rel="stylesheet" href="{{ asset('resources/assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/skin-blue.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/plugins/iCheck/all.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/AdminLTE.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/custom.css') }}">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    @else
    <link rel="stylesheet" href="{{ asset('public/css/'.env('APP_ENV').'.mailboxForm.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/plugins/iCheck/all.css') }}">
    @endif

</head>

<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        @include('elements.Admin.base-header')
        @yield('content')
        @include('elements.Admin.base-footer')
        @include('elements.Admin.base-aside')
    </div>
    <!-- ./wrapper -->
    @if(env('APP_ENV') == 'local')
    <!-- part1 js include -->
    <script defer src="{{ asset('resources/assets/js/jquery.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/bootstrap.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/adminlte.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/jquery-validate/jquery.validate.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/jquery-validate/additional.methods.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/icheck.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/jquery.confirm.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/tinymce/js/tinymce/tinymce.min.js') }}"></script>

    <!-- js message objects to access by validation plugin -->
    @include('elements.Admin.lang.validation.'.$objValidationMsgs)
    <script defer src="{{ asset('resources/assets/js/validation/'.$objValidationJs.'.js') }}"></script>

    <!-- part2 js include -->
    <script defer src="{{ asset('resources/assets/js/jscolor.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/select2.full.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/custom.js') }}"></script>
    
    @else
    <!-- part1 js include -->
    <script defer src="{{ asset('public/js/'.env('APP_ENV').'.mailboxForm.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/tinymce/js/tinymce/tinymce.min.js') }}"></script>
    
    @include('elements.Admin.lang.validation.'.$objValidationMsgs)
    <script defer src="{{ asset('resources/assets/js/validation/'.$objValidationJs.'.js') }}"></script>

    <!-- part2 js include -->
    <script defer src="{{ asset('public/js/'.env('APP_ENV').'.mailboxForm1.min.js') }}"></script>
    @endif

    <script defer src="{{ asset('resources/assets/js/jquery.fancybox.pack.js?v=2.1.5') }}"></script>
</body>

</html>