<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ ucwords(config('app.name', 'Laravel')) }} | {{$title}}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- load admin css -->
    @if(env('APP_ENV') == 'local')
    <link rel="stylesheet" href="{{ asset('resources/assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/font-awesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/ionicons.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/AdminLTE.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/blue.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/custom.css') }}">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    <!-- Google Font -->
    @else
    <link rel="stylesheet" href="{{ asset('public/css/'.env('APP_ENV').'.adminPdf.min.css') }}">
    @endif
</head>

<body class="hold-transition login-page">
    <div class="wrapper">
        @yield('content')
    </div>
    <!-- ./wrapper -->
    @if(env('APP_ENV') == 'local')
    <script defer src="{{ asset('resources/assets/js/jquery.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/bootstrap.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/adminlte.min.js') }}"></script>
    @else
    <script defer src="{{ asset('public/js/'.env('APP_ENV').'.adminPdf.min.js') }}"></script>
    @endif
</body>

</html>