<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ ucwords(config('app.name', 'Laravel')) }} | {{$title}} - {{$subTitle}}</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    @if(env('APP_ENV') == 'local')
    <link rel="stylesheet" href="{{ asset('resources/assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/AdminLTE.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/plugins/iCheck/square/blue.css')}}">
    <link rel="stylesheet" href="{{ asset('resources/assets/css/custom.css') }}">
    @else
    <link rel="stylesheet" href="{{ asset('public/css/'.env('APP_ENV').'.adminLogin.min.css') }}">
    <link rel="stylesheet" href="{{ asset('resources/assets/plugins/iCheck/square/blue.css')}}">
    @endif
</head>

<body class="hold-transition login-page">

    <div class="wrapper">
        @yield('content')
    </div>
    @if(env('APP_ENV') == 'local')
    
    <!-- part1 js include -->
    <script defer src="{{ asset('resources/assets/js/jquery.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/bootstrap.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/js/fastclick.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/iCheck/icheck.min.js') }}"></script>
    <script defer src="{{ asset('resources/assets/plugins/jquery-validate/jquery.validate.js') }}"></script>
    
    <!-- js message objects to access by validation plugin -->
    @include('elements.Admin.lang.validation.user')
    
    <!-- part2 js include -->
    <script defer src="{{ asset('resources/assets/js/validation/user.js') }}"></script>
    @else

    <!-- part1 js include -->
    <script defer src="{{ asset('public/js/'.env('APP_ENV').'.adminLogin.min.js') }}"></script>
    <!-- js message objects to access by validation plugin -->
    @include('elements.Admin.lang.validation.user')

    <!-- part2 js include -->
    <script defer src="{{ asset('public/js/'.env('APP_ENV').'.adminLogin1.min.js') }}"></script>
    @endif
</body>

</html>