<!--
 - @auther: NMG - PR
 - @Description: Javascript validation messages & constants for user module. Values are taken from-
 -  /config/admin/constants.php
 -  /resources/lang/en/admin/validation/user.php
 - @dated: 20/Nov/2019
 -->

@if($formId == 'forgotPassword')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
}
</script>
@elseif($formId == 'loginForm')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
}
</script>
@elseif($formId == 'signup')
<script>
let formId = "{{$formId}}";
let objValConst = {
    name: {
        'minLength': "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.restaurant.restaurant_name.maxLength') }}",
        'regex': "{{ config('admin.constants.restaurant.restaurant_name.regex') }}",
    },
    bio: {
        'minLength': "{{ config('admin.constants.restaurant.restaurant_bio.minLength') }}",
        'maxLength': "{{ config('admin.constants.restaurant.restaurant_bio.maxLength') }}",
        'regex': "{{ config('admin.constants.restaurant.restaurant_bio.regex') }}",
    },
    email: {
        'maxLength': "{{ config('admin.constants.restaurant.restaurant_email_id.maxLength') }}",
        'regex': "{{ config('admin.constants.restaurant.restaurant_email_id.regex') }}",
    },
    phone_number: {
        'minLength': "{{ config('admin.constants.user.phone_number.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.phone_number.maxLength') }}",
        'regex': "{{ config('admin.constants.user.phone_number.regex') }}",
    },
    address1: { 
        'minLength': "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
    },
    city: {
        'minLength': "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
    },
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    name: {
        'code': "{{__('admin/validation/restaurant.restaurant_name.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_name.required')}}",
        'string': "{{__('admin/validation/restaurant.restaurant_name.string')}}",
        'min': "{{__('admin/validation/restaurant.restaurant_name.min')}}",
        'max': "{{__('admin/validation/restaurant.restaurant_name.max')}}",
        'regex': "{{__('admin/validation/restaurant.restaurant_name.regex')}}",
    },
    bio: {
        'code': "{{__('admin/validation/restaurant.restaurant_bio.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_bio.required')}}",
        'string': "{{__('admin/validation/restaurant.restaurant_bio.string')}}",
        'min': "{{__('admin/validation/restaurant.restaurant_bio.min')}}",
        'max': "{{__('admin/validation/restaurant.restaurant_bio.max')}}",
        'regex': "{{__('admin/validation/restaurant.restaurant_bio.regex')}}",
    },
    email: {
        'code': "{{__('admin/validation/restaurant.restaurant_email_id.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_email_id.required')}}",
        'string': "{{__('admin/validation/restaurant.restaurant_email_id.string')}}",
        'email': "{{__('admin/validation/restaurant.restaurant_email_id.email')}}",
        'max': "{{__('admin/validation/restaurant.restaurant_email_id.max')}}",
        'unique': "{{__('admin/validation/restaurant.restaurant_email_id.unique')}}",
        'exists': "{{__('admin/validation/restaurant.restaurant_email_id.exists')}}",
    },
    phone_number: {
        'required': "{{__('admin/validation/restaurant.restaurant_phone_number.required')}}",
        'min': "{{__('admin/validation/user.phone_number.min')}}",
        'max': "{{__('admin/validation/user.phone_number.max')}}",
        'regex': "{{__('admin/validation/user.phone_number.regex')}}",
    },
    address1: {
        'code': "{{__('admin/validation/restaurant.restaurant_address.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_address.required')}}",
    },
    address2: {
        'code': "{{__('admin/validation/restaurant.restaurant_address2.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_address2.required')}}",
    },
    city: {
        'code': "{{__('admin/validation/restaurant.city.code')}}",
        'required': "{{__('admin/validation/restaurant.city.required')}}",
    },
    country: {  
        'code': "{{__('admin/validation/restaurant.region.code')}}",
        'required': "{{__('admin/validation/restaurant.region.required')}}",
    },
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
    password_confirmation: {
        'code': "{{__('admin/validation/user.confirm_password.code')}}",
        'required': "{{__('admin/validation/user.confirm_password.required')}}",
        'equalTo': "{{__('admin/validation/user.confirm_password.equalTo')}}",
    },
    termcondition: {
        'code': "{{__('admin/validation/restaurant.termcondition.code')}}", 
        'required': "{{__('admin/validation/restaurant.termcondition.required')}}",
    },
}
</script>

@elseif($formId == 'editRestaurant')
<script>
let formId = "{{$formId}}";
let objValConst = {
    name: {
        'minLength': "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.restaurant.restaurant_name.maxLength') }}",
        'regex': "{{ config('admin.constants.restaurant.restaurant_name.regex') }}",
    },
    bio: {
        'minLength': "{{ config('admin.constants.restaurant.restaurant_bio.minLength') }}",
        'maxLength': "{{ config('admin.constants.restaurant.restaurant_bio.maxLength') }}",
        'regex': "{{ config('admin.constants.restaurant.restaurant_bio.regex') }}",
    },
    email: {
        'maxLength': "{{ config('admin.constants.restaurant.restaurant_email_id.maxLength') }}",
        'regex': "{{ config('admin.constants.restaurant.restaurant_email_id.regex') }}",
    },
    phone_number: {
        'minLength': "{{ config('admin.constants.user.phone_number.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.phone_number.maxLength') }}",
        'regex': "{{ config('admin.constants.user.phone_number.regex') }}",
    },
    address1: { 
        'minLength': "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
    },
    city: {
        'minLength': "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
    },
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    name: {
        'code': "{{__('admin/validation/restaurant.restaurant_name.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_name.required')}}",
        'string': "{{__('admin/validation/restaurant.restaurant_name.string')}}",
        'min': "{{__('admin/validation/restaurant.restaurant_name.min')}}",
        'max': "{{__('admin/validation/restaurant.restaurant_name.max')}}",
        'regex': "{{__('admin/validation/restaurant.restaurant_name.regex')}}",
    },
    bio: {
        'code': "{{__('admin/validation/restaurant.restaurant_bio.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_bio.required')}}",
        'string': "{{__('admin/validation/restaurant.restaurant_bio.string')}}",
        'min': "{{__('admin/validation/restaurant.restaurant_bio.min')}}",
        'max': "{{__('admin/validation/restaurant.restaurant_bio.max')}}",
        'regex': "{{__('admin/validation/restaurant.restaurant_bio.regex')}}",
    },
    email: {
        'code': "{{__('admin/validation/restaurant.restaurant_email_id.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_email_id.required')}}",
        'string': "{{__('admin/validation/restaurant.restaurant_email_id.string')}}",
        'email': "{{__('admin/validation/restaurant.restaurant_email_id.email')}}",
        'max': "{{__('admin/validation/restaurant.restaurant_email_id.max')}}",
        'unique': "{{__('admin/validation/restaurant.restaurant_email_id.unique')}}",
        'exists': "{{__('admin/validation/restaurant.restaurant_email_id.exists')}}",
    },
    phone_number: {
        'required': "{{__('admin/validation/restaurant.restaurant_phone_number.required')}}",
        'min': "{{__('admin/validation/user.phone_number.min')}}",
        'max': "{{__('admin/validation/user.phone_number.max')}}",
        'regex': "{{__('admin/validation/user.phone_number.regex')}}",
    },
    address1: {
        'code': "{{__('admin/validation/restaurant.restaurant_address.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_address.required')}}",
    },
    address2: {
        'code': "{{__('admin/validation/restaurant.restaurant_address2.code')}}",
        'required': "{{__('admin/validation/restaurant.restaurant_address2.required')}}",
    },
    city: {
        'code': "{{__('admin/validation/restaurant.city.code')}}",
        'required': "{{__('admin/validation/restaurant.city.required')}}",
    },
    country: {  
        'code': "{{__('admin/validation/restaurant.region.code')}}",
        'required': "{{__('admin/validation/restaurant.region.required')}}",
    },
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
    password_confirmation: {
        'code': "{{__('admin/validation/user.confirm_password.code')}}",
        'required': "{{__('admin/validation/user.confirm_password.required')}}",
        'equalTo': "{{__('admin/validation/user.confirm_password.equalTo')}}",
    },
    termcondition: {
        'code': "{{__('admin/validation/restaurant.termcondition.code')}}", 
        'required': "{{__('admin/validation/restaurant.termcondition.required')}}",
    },
}
</script>
@elseif($formId == 'changePassword')
<script>
let formId = "{{$formId}}";
let objValConst = {
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
    new_password: {
        'code': "{{__('admin/validation/user.new_password.code')}}",
        'required': "{{__('admin/validation/user.new_password.required')}}",
        'string': "{{__('admin/validation/user.new_password.string')}}",
        'min': "{{__('admin/validation/user.new_password.min')}}",
        'max': "{{__('admin/validation/user.new_password.max')}}",
        'regex': "{{__('admin/validation/user.new_password.regex')}}",
        'current_password': "{{__('admin/validation/user.new_password.current_password')}}",
    },
    new_password_confirmation: {
        'code': "{{__('admin/validation/user.new_password_confirmation.code')}}",
        'required': "{{__('admin/validation/user.new_password_confirmation.required')}}",
        'equalTo': "{{__('admin/validation/user.new_password_confirmation.equalTo')}}",
    },
}
</script>
@elseif($formId == 'resetPasswordForm')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    new_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    new_password: {
        'code': "{{__('admin/validation/user.new_password.code')}}",
        'required': "{{__('admin/validation/user.new_password.required')}}",
        'string': "{{__('admin/validation/user.new_password.string')}}",
        'min': "{{__('admin/validation/user.new_password.min')}}",
        'max': "{{__('admin/validation/user.new_password.max')}}",
        'regex': "{{__('admin/validation/user.new_password.regex')}}",
        'current_password': "{{__('admin/validation/user.new_password.current_password')}}",
    },
    new_password_confirmation: {
        'code': "{{__('admin/validation/user.new_password_confirmation.code')}}",
        'required': "{{__('admin/validation/user.new_password_confirmation.required')}}",
        'equalTo': "{{__('admin/validation/user.new_password_confirmation.equalTo')}}",
    },
}
</script>
@elseif($formId == 'restaurantResetPassword')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    otp: {
        'minLength': "{{ config('admin.constants.restaurant.otp.minLength') }}",
        'maxLength': "{{ config('admin.constants.restaurant.otp.maxLength') }}",
    },
    new_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    otp: {
        'code': "{{__('admin/validation/restaurant.otp.code')}}",
        'required': "{{__('admin/validation/restaurant.otp.required')}}",
        'min': "{{__('admin/validation/restaurant.otp.min')}}",
        'max': "{{__('admin/validation/restaurant.otp.max')}}",
    },
    new_password: {
        'code': "{{__('admin/validation/user.new_password.code')}}",
        'required': "{{__('admin/validation/user.new_password.required')}}",
        'string': "{{__('admin/validation/user.new_password.string')}}",
        'min': "{{__('admin/validation/user.new_password.min')}}",
        'max': "{{__('admin/validation/user.new_password.max')}}",
        'regex': "{{__('admin/validation/user.new_password.regex')}}",
        'current_password': "{{__('admin/validation/user.new_password.current_password')}}",
    },
    new_password_confirmation: {
        'code': "{{__('admin/validation/user.new_password_confirmation.code')}}",
        'required': "{{__('admin/validation/user.new_password_confirmation.required')}}",
        'equalTo': "{{__('admin/validation/user.new_password_confirmation.equalTo')}}",
    },
}
</script>
@elseif($formId == 'profileEditForm')
<script>
let formId = "{{$formId}}";
let objValConst = {
    first_name: {
        'minLength': "{{ config('admin.constants.user.first_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.first_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.first_name.regex') }}",
    },
    last_name: {
        'minLength': "{{ config('admin.constants.user.last_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.last_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.last_name.regex') }}",
    },
    avatar: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",
    },
}
let objValMsgConst = {
    first_name: {
        'code': "{{__('admin/validation/user.first_name.code')}}",
        'required': "{{__('admin/validation/user.first_name.required')}}",
        'string': "{{__('admin/validation/user.first_name.string')}}",
        'min': "{{__('admin/validation/user.first_name.min')}}",
        'max': "{{__('admin/validation/user.first_name.max')}}",
        'regex': "{{__('admin/validation/user.first_name.regex')}}",
    },
    last_name: {
        'code': "{{__('admin/validation/user.last_name.code')}}",
        'required': "{{__('admin/validation/user.last_name.required')}}",
        'string': "{{__('admin/validation/user.last_name.string')}}",
        'min': "{{__('admin/validation/user.last_name.min')}}",
        'max': "{{__('admin/validation/user.last_name.max')}}",
        'regex': "{{__('admin/validation/user.last_name.regex')}}",
    },
    avatar: {
        'code': "{{__('admin/validation/user.avatar.code')}}",
        'required': "{{__('admin/validation/user.avatar.required')}}",
        'image': "{{__('admin/validation/user.avatar.image')}}",
        'mimes': "{{__('admin/validation/user.avatar.mimes')}}",
        'filesize': "{{__('admin/validation/user.avatar.filesize')}}",
    }
}
</script>

@else
<script>
let formId = "{{$formId}}";
let objValConst = {
    user_name: {
        minLength: "{{ config('admin.constants.user.user_name.minLength') }}",
        maxLength: "{{ config('admin.constants.user.user_name.maxLength') }}",
        regex: "{{ config('admin.constants.user.user_name.regex') }}",
    },
    email: {
        'minLength': "{{ config('admin.constants.user.email.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    phone_number: {
        'minLength': "{{ config('admin.constants.user.phone_number.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.phone_number.maxLength') }}",
        'regex': "{{ config('admin.constants.user.phone_number.regex') }}",
    },
    mobile_no: {
        'minLength': "{{ config('admin.constants.user.mobile_no.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.mobile_no.maxLength') }}",
        'regex': "{{ config('admin.constants.user.mobile_no.regex') }}",
    },

    pincode: {
        'minLength': "{{ config('admin.constants.user.pincode.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.pincode.maxLength') }}",
        'regex': "{{ config('admin.constants.user.pincode.regex') }}",
    },
    
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    confirm_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    first_name: {
        'minLength': "{{ config('admin.constants.user.first_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.first_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.first_name.regex') }}",
    },
    last_name: {
        'minLength': "{{ config('admin.constants.user.last_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.last_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.last_name.regex') }}",
    },
    avatar: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",
    },
};
let objValMsgConst = {
    role_id: {
        'code': "{{__('admin/validation/user.role_id.code')}}",
        'required': "{{__('admin/validation/user.role_id.required')}}",
    },
    facility_id: {
        'code': "{{__('admin/validation/user.facility_id.code')}}",
        'required': "{{__('admin/validation/user.facility_id.required')}}",
    },
    department_id: {
        'code': "{{__('admin/validation/user.department_id.code')}}",
        'required': "{{__('admin/validation/user.department_id.required')}}",
    },
    title_id: {
        'code': "{{__('admin/validation/user.title_id.code')}}",
        'required': "{{__('admin/validation/user.title_id.required')}}",
    },
    user_name: {
        'code': "{{__('admin/validation/user.user_name.code')}}",
        'required': "{{__('admin/validation/user.user_name.required')}}",
        'string': "{{__('admin/validation/user.user_name.string')}}",
        'min': "{{__('admin/validation/user.user_name.min')}}",
        'max': "{{__('admin/validation/user.user_name.max')}}",
        'regex': "{{__('admin/validation/user.user_name.regex')}}",
    },
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'regex': "{{__('admin/validation/user.email.regex')}}",
        'min': "{{__('admin/validation/user.email.min')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    phone_number: {
        'min': "{{__('admin/validation/user.phone_number.min')}}",
        'max': "{{__('admin/validation/user.phone_number.max')}}",
        'regex': "{{__('admin/validation/user.phone_number.regex')}}",
    },
    pincode: {
        'min': "{{__('admin/validation/user.pincode.min')}}",
        'max': "{{__('admin/validation/user.pincode.max')}}",
        'regex': "{{__('admin/validation/user.pincode.regex')}}",
    },
    mobile_no: {
        'code': "{{__('admin/validation/user.mobile_no.code')}}",
        'required': "{{__('admin/validation/user.mobile_no.required')}}",
        'min': "{{__('admin/validation/user.mobile_no.min')}}",
        'max': "{{__('admin/validation/user.mobile_no.max')}}",
        'regex': "{{__('admin/validation/user.mobile_no.regex')}}",
    },
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
    confirm_password: {
        'code': "{{__('admin/validation/user.confirm_password.code')}}",
        'required': "{{__('admin/validation/user.confirm_password.required')}}",
        'equalTo': "{{__('admin/validation/user.confirm_password.equalTo')}}",
    },
    first_name: {
        'code': "{{__('admin/validation/user.first_name.code')}}",
        'required': "{{__('admin/validation/user.first_name.required')}}",
        'string': "{{__('admin/validation/user.first_name.string')}}",
        'min': "{{__('admin/validation/user.first_name.min')}}",
        'max': "{{__('admin/validation/user.first_name.max')}}",
        'regex': "{{__('admin/validation/user.first_name.regex')}}",
    },
    last_name: {
        'code': "{{__('admin/validation/user.last_name.code')}}",
        'required': "{{__('admin/validation/user.last_name.required')}}",
        'string': "{{__('admin/validation/user.last_name.string')}}",
        'min': "{{__('admin/validation/user.last_name.min')}}",
        'max': "{{__('admin/validation/user.last_name.max')}}",
        'regex': "{{__('admin/validation/user.last_name.regex')}}",
    },
    avatar: {
        'code': "{{__('admin/validation/user.avatar.code')}}",
        'required': "{{__('admin/validation/user.avatar.required')}}",
        'image': "{{__('admin/validation/user.avatar.image')}}",
        'mimes': "{{__('admin/validation/user.avatar.mimes')}}",
        'filesize': "{{__('admin/validation/user.avatar.filesize')}}",
    }
}
</script>
@endif
