<!--
 - @auther: NMG - PR
 - @Description: Javascript validation messages & constants for user module. Values are taken from-
 -  /config/admin/constants.php
 -  /resources/lang/en/admin/validation/user.php
 - @dated: 20/Nov/2019
 -->

@if($formId == 'forgotPassword')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
}
</script>
@elseif($formId == 'loginForm')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
}
</script>
@elseif($formId == 'changePassword')
<script>
let formId = "{{$formId}}";
let objValConst = {
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
    new_password: {
        'code': "{{__('admin/validation/user.new_password.code')}}",
        'required': "{{__('admin/validation/user.new_password.required')}}",
        'string': "{{__('admin/validation/user.new_password.string')}}",
        'min': "{{__('admin/validation/user.new_password.min')}}",
        'max': "{{__('admin/validation/user.new_password.max')}}",
        'regex': "{{__('admin/validation/user.new_password.regex')}}",
        'current_password': "{{__('admin/validation/user.new_password.current_password')}}",
    },
    new_password_confirmation: {
        'code': "{{__('admin/validation/user.new_password_confirmation.code')}}",
        'required': "{{__('admin/validation/user.new_password_confirmation.required')}}",
        'equalTo': "{{__('admin/validation/user.new_password_confirmation.equalTo')}}",
    },
}
</script>
@elseif($formId == 'resetPasswordForm')
<script>
let formId = "{{$formId}}";
let objValConst = {
    email: {
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    new_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    new_password_confirmation: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
}
let objValMsgConst = {
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'email': "{{__('admin/validation/user.email.email')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    new_password: {
        'code': "{{__('admin/validation/user.new_password.code')}}",
        'required': "{{__('admin/validation/user.new_password.required')}}",
        'string': "{{__('admin/validation/user.new_password.string')}}",
        'min': "{{__('admin/validation/user.new_password.min')}}",
        'max': "{{__('admin/validation/user.new_password.max')}}",
        'regex': "{{__('admin/validation/user.new_password.regex')}}",
        'current_password': "{{__('admin/validation/user.new_password.current_password')}}",
    },
    new_password_confirmation: {
        'code': "{{__('admin/validation/user.new_password_confirmation.code')}}",
        'required': "{{__('admin/validation/user.new_password_confirmation.required')}}",
        'equalTo': "{{__('admin/validation/user.new_password_confirmation.equalTo')}}",
    },
}
</script>
@elseif($formId == 'editDeliveryPerson')
<script>
let formId = "{{$formId}}";
let objValConst = {
    first_name: {
        'minLength': "{{ config('admin.constants.user.first_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.first_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.first_name.regex') }}",
    },
    last_name: {
        'minLength': "{{ config('admin.constants.user.last_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.last_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.last_name.regex') }}",
    },

    user_name: {
        minLength: "{{ config('admin.constants.user.user_name.minLength') }}",
        maxLength: "{{ config('admin.constants.user.user_name.maxLength') }}",
        regex: "{{ config('admin.constants.user.user_name.regex') }}",
    },

    email: {
        'minLength': "{{ config('admin.constants.user.email.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    phone_number: {
        'minLength': "{{ config('admin.constants.delivery-person.phone_number.minLength') }}",
        'maxLength': "{{ config('admin.constants.delivery-person.phone_number.maxLength') }}",
        'regex': "{{ config('admin.constants.delivery-person.phone_number.regex') }}",
    },
    mobile_no: {
        'minLength': "{{ config('admin.constants.user.mobile_no.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.mobile_no.maxLength') }}",
        'regex': "{{ config('admin.constants.user.mobile_no.regex') }}",
    },

    pincode: {
        'minLength': "{{ config('admin.constants.user.pincode.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.pincode.maxLength') }}",
        'regex': "{{ config('admin.constants.user.pincode.regex') }}",
    },
    

    avatar: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",
    },

    age: {
        'minLength': "{{ config('admin.constants.delivery-person.age.minLength') }}",
        'maxLength': "{{ config('admin.constants.delivery-person.age.maxLength') }}",
        'regex': "{{ config('admin.constants.delivery-person.age.regex') }}",
    },

    /*id_proof: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",    
    },*/

    account_details: {
        'minLength': "{{ config('admin.constants.delivery-person.account_details.minLength') }}",
        'regex': "{{ config('admin.constants.delivery-person.account_details.regex') }}",
    },
    /*vehicle_info: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",
    },
    driving_license: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",
    },*/
}
let objValMsgConst = {
    first_name: {
        'code': "{{__('admin/validation/user.first_name.code')}}",
        'required': "{{__('admin/validation/user.first_name.required')}}",
        'string': "{{__('admin/validation/user.first_name.string')}}",
        'min': "{{__('admin/validation/user.first_name.min')}}",
        'max': "{{__('admin/validation/user.first_name.max')}}",
        'regex': "{{__('admin/validation/user.first_name.regex')}}",
    },
    last_name: {
        'code': "{{__('admin/validation/user.last_name.code')}}",
        'required': "{{__('admin/validation/user.last_name.required')}}",
        'string': "{{__('admin/validation/user.last_name.string')}}",
        'min': "{{__('admin/validation/user.last_name.min')}}",
        'max': "{{__('admin/validation/user.last_name.max')}}",
        'regex': "{{__('admin/validation/user.last_name.regex')}}",
    },
    user_name: {
        'code': "{{__('admin/validation/user.user_name.code')}}",
        'required': "{{__('admin/validation/user.user_name.required')}}",
        'string': "{{__('admin/validation/user.user_name.string')}}",
        'min': "{{__('admin/validation/user.user_name.min')}}",
        'max': "{{__('admin/validation/user.user_name.max')}}",
        'regex': "{{__('admin/validation/user.user_name.regex')}}",
    },

    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'regex': "{{__('admin/validation/user.email.regex')}}",
        'min': "{{__('admin/validation/user.email.min')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    phone_number: {
        'min': "{{__('admin/validation/user.phone_number.min')}}",
        'max': "{{__('admin/validation/user.phone_number.max')}}",
        'regex': "{{__('admin/validation/user.phone_number.regex')}}",
    },
    pincode: {
        'min': "{{__('admin/validation/user.pincode.min')}}",
        'max': "{{__('admin/validation/user.pincode.max')}}",
        'regex': "{{__('admin/validation/user.pincode.regex')}}",
    },
    mobile_no: {
        'code': "{{__('admin/validation/user.mobile_no.code')}}",
        'required': "{{__('admin/validation/user.mobile_no.required')}}",
        'min': "{{__('admin/validation/user.mobile_no.min')}}",
        'max': "{{__('admin/validation/user.mobile_no.max')}}",
        'regex': "{{__('admin/validation/user.mobile_no.regex')}}",
    },
    avatar: {
        'code': "{{__('admin/validation/user.avatar.code')}}",
        'required': "{{__('admin/validation/user.avatar.required')}}",
        'image': "{{__('admin/validation/user.avatar.image')}}",
        'mimes': "{{__('admin/validation/user.avatar.mimes')}}",
        'filesize': "{{__('admin/validation/user.avatar.filesize')}}",
    },
    age: {
        'code': "{{__('admin/validation/delivery-person.age.code')}}",
        'required': "{{__('admin/validation/delivery-person.age.required')}}",
        
        'min': "{{__('admin/validation/delivery-person.age.min')}}",
        'max': "{{__('admin/validation/delivery-person.age.max')}}",
        'regex': "{{__('admin/validation/delivery-person.age.regex')}}",
    },

    id_proof: {
        'code': "{{__('admin/validation/delivery-person.id_proof.code')}}",
        'required': "{{__('admin/validation/delivery-person.id_proof.required')}}",
        'image': "{{__('admin/validation/delivery-person.id_proof.image')}}",
        'mimes': "{{__('admin/validation/delivery-person.id_proof.mimes')}}",
        'filesize': "{{__('admin/validation/delivery-person.id_proof.filesize')}}",
        
    },

    account_details: {
        'code': "{{__('admin/validation/delivery-person.account_details.code')}}",
        'required': "{{__('admin/validation/delivery-person.account_details.required')}}",    
        'min': "{{__('admin/validation/delivery-person.account_details.min')}}",
        'regex': "{{__('admin/validation/delivery-person.account_details.regex')}}",
    },

    vehicle_info: {
        'code': "{{__('admin/validation/delivery-person.vehicle_info.code')}}",
        'required': "{{__('admin/validation/delivery-person.vehicle_info.required')}}",    
        'image': "{{__('admin/validation/delivery-person.vehicle_info.image')}}",
        'mimes': "{{__('admin/validation/delivery-person.vehicle_info.mimes')}}",
        'filesize': "{{__('admin/validation/delivery-person.vehicle_info.filesize')}}",
    },

    driving_license: {
        'code': "{{__('admin/validation/delivery-person.driving_license.code')}}",
        'required': "{{__('admin/validation/delivery-person.driving_license.required')}}",    
        'image': "{{__('admin/validation/delivery-person.driving_license.image')}}",
        'mimes': "{{__('admin/validation/delivery-person.driving_license.mimes')}}",
        'filesize': "{{__('admin/validation/delivery-person.driving_license.filesize')}}",
    },

    role_id: {
        'code': "{{__('admin/validation/user.role_id.code')}}",
        'required': "{{__('admin/validation/user.role_id.required')}}",
    },
    facility_id: {
        'code': "{{__('admin/validation/user.facility_id.code')}}",
        'required': "{{__('admin/validation/user.facility_id.required')}}",
    },
    department_id: {
        'code': "{{__('admin/validation/user.department_id.code')}}",
        'required': "{{__('admin/validation/user.department_id.required')}}",
    },
    title_id: {
        'code': "{{__('admin/validation/user.title_id.code')}}",
        'required': "{{__('admin/validation/user.title_id.required')}}",
    },
}
</script>
@else
<script>
let formId = "{{$formId}}";
let objValConst = {
    user_name: {
        minLength: "{{ config('admin.constants.user.user_name.minLength') }}",
        maxLength: "{{ config('admin.constants.user.user_name.maxLength') }}",
        regex: "{{ config('admin.constants.user.user_name.regex') }}",
    },
    email: {
        'minLength': "{{ config('admin.constants.user.email.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.email.maxLength') }}",
        'regex': "{{ config('admin.constants.user.email.regex') }}",
    },
    phone_number: {
        'minLength': "{{ config('admin.constants.user.phone_number.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.phone_number.maxLength') }}",
        'regex': "{{ config('admin.constants.user.phone_number.regex') }}",
    },
    mobile_no: {
        'minLength': "{{ config('admin.constants.user.mobile_no.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.mobile_no.maxLength') }}",
        'regex': "{{ config('admin.constants.user.mobile_no.regex') }}",
    },

    pincode: {
        'minLength': "{{ config('admin.constants.user.pincode.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.pincode.maxLength') }}",
        'regex': "{{ config('admin.constants.user.pincode.regex') }}",
    },
    
    password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    confirm_password: {
        'minLength': "{{ config('admin.constants.user.password.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.password.maxLength') }}",
        'regex': "{{ config('admin.constants.user.password.regex') }}",
    },
    first_name: {
        'minLength': "{{ config('admin.constants.user.first_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.first_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.first_name.regex') }}",
    },
    last_name: {
        'minLength': "{{ config('admin.constants.user.last_name.minLength') }}",
        'maxLength': "{{ config('admin.constants.user.last_name.maxLength') }}",
        'regex': "{{ config('admin.constants.user.last_name.regex') }}",
    },
    avatar: {
        'size': "{{ config('admin.constants.user.avatar.size') }}",
    },
};
let objValMsgConst = {
    role_id: {
        'code': "{{__('admin/validation/user.role_id.code')}}",
        'required': "{{__('admin/validation/user.role_id.required')}}",
    },
    facility_id: {
        'code': "{{__('admin/validation/user.facility_id.code')}}",
        'required': "{{__('admin/validation/user.facility_id.required')}}",
    },
    department_id: {
        'code': "{{__('admin/validation/user.department_id.code')}}",
        'required': "{{__('admin/validation/user.department_id.required')}}",
    },
    title_id: {
        'code': "{{__('admin/validation/user.title_id.code')}}",
        'required': "{{__('admin/validation/user.title_id.required')}}",
    },
    user_name: {
        'code': "{{__('admin/validation/user.user_name.code')}}",
        'required': "{{__('admin/validation/user.user_name.required')}}",
        'string': "{{__('admin/validation/user.user_name.string')}}",
        'min': "{{__('admin/validation/user.user_name.min')}}",
        'max': "{{__('admin/validation/user.user_name.max')}}",
        'regex': "{{__('admin/validation/user.user_name.regex')}}",
    },
    email: {
        'code': "{{__('admin/validation/user.email.code')}}",
        'required': "{{__('admin/validation/user.email.required')}}",
        'string': "{{__('admin/validation/user.email.string')}}",
        'regex': "{{__('admin/validation/user.email.regex')}}",
        'min': "{{__('admin/validation/user.email.min')}}",
        'max': "{{__('admin/validation/user.email.max')}}",
        'unique': "{{__('admin/validation/user.email.unique')}}",
        'exists': "{{__('admin/validation/user.email.exists')}}",
    },
    phone_number: {
        'min': "{{__('admin/validation/user.phone_number.min')}}",
        'max': "{{__('admin/validation/user.phone_number.max')}}",
        'regex': "{{__('admin/validation/user.phone_number.regex')}}",
    },
    pincode: {
        'min': "{{__('admin/validation/user.pincode.min')}}",
        'max': "{{__('admin/validation/user.pincode.max')}}",
        'regex': "{{__('admin/validation/user.pincode.regex')}}",
    },
    mobile_no: {
        'code': "{{__('admin/validation/user.mobile_no.code')}}",
        'required': "{{__('admin/validation/user.mobile_no.required')}}",
        'min': "{{__('admin/validation/user.mobile_no.min')}}",
        'max': "{{__('admin/validation/user.mobile_no.max')}}",
        'regex': "{{__('admin/validation/user.mobile_no.regex')}}",
    },
    password: {
        'code': "{{__('admin/validation/user.password.code')}}",
        'required': "{{__('admin/validation/user.password.required')}}",
        'string': "{{__('admin/validation/user.password.string')}}",
        'min': "{{__('admin/validation/user.password.min')}}",
        'max': "{{__('admin/validation/user.password.max')}}",
        'regex': "{{__('admin/validation/user.password.regex')}}",
        'current_password': "{{__('admin/validation/user.password.current_password')}}",
    },
    confirm_password: {
        'code': "{{__('admin/validation/user.confirm_password.code')}}",
        'required': "{{__('admin/validation/user.confirm_password.required')}}",
        'equalTo': "{{__('admin/validation/user.confirm_password.equalTo')}}",
    },
    first_name: {
        'code': "{{__('admin/validation/user.first_name.code')}}",
        'required': "{{__('admin/validation/user.first_name.required')}}",
        'string': "{{__('admin/validation/user.first_name.string')}}",
        'min': "{{__('admin/validation/user.first_name.min')}}",
        'max': "{{__('admin/validation/user.first_name.max')}}",
        'regex': "{{__('admin/validation/user.first_name.regex')}}",
    },
    last_name: {
        'code': "{{__('admin/validation/user.last_name.code')}}",
        'required': "{{__('admin/validation/user.last_name.required')}}",
        'string': "{{__('admin/validation/user.last_name.string')}}",
        'min': "{{__('admin/validation/user.last_name.min')}}",
        'max': "{{__('admin/validation/user.last_name.max')}}",
        'regex': "{{__('admin/validation/user.last_name.regex')}}",
    },
    avatar: {
        'code': "{{__('admin/validation/user.avatar.code')}}",
        'required': "{{__('admin/validation/user.avatar.required')}}",
        'image': "{{__('admin/validation/user.avatar.image')}}",
        'mimes': "{{__('admin/validation/user.avatar.mimes')}}",
        'filesize': "{{__('admin/validation/user.avatar.filesize')}}",
    }
}
</script>
@endif
