@php
$requestSegments = Request::segments();
$actionName =  !empty($requestSegments[2]) ? $requestSegments[2]:'' ;
$routeArray = request()->route()->getAction();
$controllerAction = class_basename($routeArray['controller']);
list($controllerC, $action) = explode('@', $controllerAction);
$controller = str_replace('-controller', '', str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($controllerC, '-')));
$orgAction = $action;
$action = str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($action, '-'));
$module = new \app\Model\Admin\Modules();
$roleId = \Auth::guard('admin')->user()->role_id;

$modules = $module->fetchMenuList($roleId);
@endphp

<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
        <ul class="sidebar-menu" data-widget="tree">
            <li class="{{$action == 'dashboard' ? 'active' : ''}}">
                <a href="{{url('/'.config("admin.constants.ADMIN_ROUTE_NAME").'/dashboard')}}">
                    <i class="fa fa-tachometer"></i>
                    <span>Manage Dashboard</span>
                </a>
            </li>
            @foreach($modules as $module)
            @php
            $treeClass = [];
            $activeClass = false;
            @endphp
            @if(count($module->children))
            @php
            $treeClass[] = 'treeview';
            @endphp
            @endif
            @if((isset($module->getPermissions[0]) && $module->getPermissions[0]->role_id == \Auth::guard('admin')->user()->role_id) || \Auth::guard('admin')->user()->role_id == config('admin.constants.SuperAdminRole'))
            @if(count($module->children))
            @foreach($module->children as $child)
            @if((isset($child->getPermissions[0]) && $child->getPermissions[0]->role_id == \Auth::guard('admin')->user()->role_id) || \Auth::guard('admin')->user()->role_id == config('admin.constants.SuperAdminRole'))
            @php
            $childController = strlen($child->controller) > 0?str_replace('-controller', '', str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($child->controller, '-'))):'';
            @endphp
            @if($childController == $controller)
            @php
            $treeClass[] = 'menu-open';
            $activeClass = true;
            @endphp
            @endif
            @endif
            @endforeach
            @else
            @php
            $childController = strlen($module->controller) > 0?str_replace('-controller', '', str_replace('_', '-', Doctrine\Common\Inflector\Inflector::tableize($module->controller, '-'))):'';
            @endphp
            @if($childController == $controller)
            @php
            $treeClass[] = 'active';
            @endphp
            @endif
            @endif
            <li class="{{implode(' ', $treeClass)}}">
                <a href="{{($module->path)?url('/'.config('admin.constants.ADMIN_ROUTE_NAME').$module->path):'javascript:;'}}">
                    <i class="{{$module->icon_class}}"></i>
                    <span>{{$module->title}}</span>

                    @if(count($module->children))
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                    @endif
                </a>
                @if(count($module->children))
                <ul class="treeview-menu{{($activeClass)?' active':''}}" style="{{$activeClass?'display:block;':''}}">
                    @foreach($module->children as $child)
                    @if((isset($child->getPermissions[0]) && $child->getPermissions[0]->role_id == \Auth::guard('admin')->user()->role_id) || \Auth::guard('admin')->user()->role_id == config('admin.constants.SuperAdminRole'))
                    <li class="<?= !empty($controller) && ($controllerC == $child->controller) ? 'active child' : ''
?>">

                        <a href="{{($child->path)?url('/'.config('admin.constants.ADMIN_ROUTE_NAME').$child->path):'javascript:;'}}">
                            <i class="{{$child->icon_class}}"></i>
                            <span>{{$child->title}}</span>
                        </a>
                    </li>
                    @endif
                    @endforeach

                </ul>
                @endif
            </li>
            @endif
            @endforeach
        </ul>

    </section>
</aside>
<style>
    .sidebar-menus {
        display: block;
    }
</style>
