@extends('layouts.Vendor.vendorRegister')
@php
$emailFlag = $passFlag = false;
@endphp
@section('content')

<div class="vertical-box">
    <div class="border-box">
        <h1>Verification Code</h1>
        <p>Please enter the verification code sent to your registered email Id</p>
        @include('Vendor.flash_message')
        {!! Form::open(['method' => 'POST', 'class' => 'form-section verification', 'id'=> $formId]) !!}
        <div class="form-group">
            <div class="verification-code">Enter Verification Code</div>
            <div class="row d-flex verification-no">
                <div class="col">
                    <input type="number" name="otp[]" class="form-control otp-input" tabindex="11" minlength="1" maxlength="1" autofocus=""
                        required />
                </div>
                <div class="col"><input type="number" name="otp[]" minlength="1" tabindex="12" maxlength="1" class="form-control otp-input"
                        required /></div>
                <div class="col"><input type="number" name="otp[]" minlength="1" tabindex="13" maxlength="1"  class="form-control otp-input"
                        required /></div>
                <div class="col"><input type="number" name="otp[]" minlength="1" tabindex="14" maxlength="1" class="form-control otp-input"
                        required /></div>
            </div>
            <span id="otp_error" class="validation-error"></span>

            <div class="form-group time" id="remaining-div">
                Remaining time: <strong id="remaining-time"></strong>
            </div>
        </div>
        <div id="countdownTest"></div>
        <div class="form-group">
            {{ Form::input('submit', 'submit', 'Verify now', array('class'=>'btn btn-primary w-100', 
					               'id'=> 'verifynow'))}}
        </div>
        {{Form::close()}}
        <div class="form-group form-section verification">
            <button class='btn btn-primary w-100' style="display: none;" id="resendOtp"> Resend OTP</button>
        </div>
    </div>
    <!--border-box End-->
    <div class="back-btn">
        <a href="{{$url.'/sign-up'}}">Back to previous</a>
    </div>
</div>
<!-- wrapper End -->

<!------ Add Comment modal Popup ------>
<div class="modal fade" id="password-changed" tabindex='-1' aria-modal="true">
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content success-model">
                <div class="modal-body">
                    <div class="yes-icon"><span></span></div>
                    <h3>Congratulations!</h3>
                    <p>You account has been created successfully</p>
                    <a href="{{$url.'/webRegister'}}" class="btn btn-primary">Continue</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let restaurantURL = "{{\Config('admin.path.VENDOR_BASE_URL')}}";

$(function(){
    startCountTimer();

});


function startCountTimer(){
    var timer2 = "1:01";
    var interval = setInterval(function() {
    var timer = timer2.split(':');
    var minutes = parseInt(timer[0], 10);
    var seconds = parseInt(timer[1], 10);
    $("#resendOtp").hide();
    $("#verifynow").show();
    $("#remaining-div").show();
    if(minutes == 0 && seconds == 0){
        clearInterval(interval);
        $("#verifynow").hide();
        $("#resendOtp").show();
        $("#remaining-div").hide();
        return false;
    }
    else{
        --seconds;
        minutes = (seconds < 0) ? --minutes : minutes;
        seconds = (seconds < 0) ? 59 : seconds;
        seconds = (seconds < 10) ? '0' + seconds : seconds;
        $('#remaining-time').html(minutes + ':' + seconds);
        timer2 = minutes + ':' + seconds;
        }
    }, 1000);
}

$(document).on('click' , '#resendOtp' , function(){ 
  var baseUrl = restaurantURL+'/send-otp';
  var _token = $('meta[name="csrf-token"]').attr("content");
    $.ajax({
      url: baseUrl,
      type: "get",
      data: {
          _token: _token,
      },
      success: function(data) {
          if (data.success) {
            startCountTimer();
          }
      },
      error: function(xhr, status, error) {
          alert("Access denined");
      }
  });
});
</script>
@endsection