@extends('layouts.Vendor.vendorLogin')
@php
$emailFlag = $passFlag = false;
@endphp
@section('content')
		<div class="vertical-box reset">
			<div class="border-box">
				<div class="reset-inner">
					<h1>Reset Password?</h1>
					<p>Enter your email address that you used to sign up your account</p>	
					@include('Admin.flash_message')			
                 </div>
				{!! Form::open(['method' => 'POST', 'class' => 'form-section', 'id'=> $formId]) !!}	
					<div class="form-group">
						{{  Form::label('Email Address') }}
				        {{ Form::email('email', $userEmail , array('class'=>'form-control required email', 'id'=>'email','placeholder' => 'thespicykitchen@gmail.com' , 'readonly'=>true)) }}
					</div>
					<div class="form-group">
						<label>Verification Code<span class="required">*</span></label>
						{{ Form::number('otp', null, array('class'=>'form-control required', 'id'=>'otp','placeholder' => 'Enter verification code')) }}
					</div>
					<div class="form-group">
						<label>New Password<span class="required">*</span></label>
						<div class="password-input">
							<!-- {{ Form::password('new_password', array('class'=>'form-control', 'id'=>'new_password','placeholder' => 'Enter new password')) }} -->
							<input type="password" id="new_password" name="new_password" class="form-control required"
                            placeholder="Enter new password">

							<div class="pshow-icon">
								<a href="javascript:void(0)"><span toggle="#password-field" class="show-eye toggle-password-new"></span></a>
							</div>
						</div>
					</div>
					<div class="form-group">
						<label>Confirm Password<span class="required">*</span></label>
						<div class="password-input">
							<!-- {{ Form::password('new_password_confirmation', array('class'=>'form-control', 'id'=>'new_password_confirmation','placeholder' => 'Re-enter new password')) }} -->
							<input type="password" id="new_password_confirmation" name="new_password_confirmation" 
							class="form-control required" placeholder="Re-enter new password">

							<div class="pshow-icon">
								<a href="javascript:void(0)"><span toggle="#password-field2" class="show-eye toggle-password-conf"></span></a>
							</div>
						</div>
					</div>
					<div class="form-group">
					   {{ Form::submit('Submit', array('class'=>'btn btn-primary w-100 ')) }}	
					</div>						
				{{Form::close()}}			
			</div><!--border-box End-->
			<div class="back-btn">
				<a href="{{ Url('securerestaurant/forgot-password')}}">Back to previous</a>
			</div>
		</div>
	<!-- /.reset password-box -->


	@if(!empty($showPopUp))
	<!------ Add Comment modal Popup ------>
<div class="modal fade" id="password-changed" tabindex='-1' aria-modal="true">
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content success-model">
                <div class="modal-body">
                    <div class="yes-icon"><span></span></div>
                    <h3>Password Changed!</h3>
                    <p>Your password has been changed successfully</p>
                    <a href="{{$url.'/webRegister'}}" class="btn btn-primary">Login</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
	$(document).ready(function(){
		$("#password-changed").modal({
			backdrop: 'static', keyboard: false
		});
	});
</script>

@endif

@endsection