@extends('layouts.Vendor.vendorLogin')
@php
$emailFlag = $passFlag = false;
@endphp
@section('content')
<section class="login-page">
	<div class="login-container">
		<article class="lft-section">
			<div class="logo">
				<a href="{{$url}}"><img src="{{ asset('resources/assets/vendor/images/logo.png') }}" alt="" title=""></a>
			</div>
			
			<h1>Grow Your Business</h1>
			<p>Reach new customers, increase your sales and grow your business.</p>
			<figure>
				<img src="{{ asset('resources/assets/vendor/images/order.png') }}" alt="" title="">
			</figure>
		</article>
		<article class="rgt-section user-login">                    
			<h2>Welcome Back!</h2>
			<p>Log in to your account</p>
			@include('Admin.flash_message')
			{!! Form::open(['method' => 'POST', 'class' => 'form-section', 'id'=> $formId]) !!}
			
				<div class="form-group">
					{{  Form::label('Email Address') }}
					{{ Form::email('email', null, array('class'=>'form-control required email', 'id'=>'email','placeholder' => 'Enter your email address')) }}
				</div>
				<div class="form-element">
				<div class="form-group mb-0">
					{{  Form::label('Password') }}
					<div class="password-input">
						<!-- {{ Form::input('password', 'password', null, array('class'=>'form-control required', 'id'=>'password', 'placeholder' => 'Enter your password'))}}
                          -->
                         <input type="password" id="password" name="password" class="form-control required"
                            placeholder="Enter your password">

						<div class="pshow-icon">
							<a href="javascript:void(0)">
								<span toggle="#password-field" class="show-eye toggle-password"></span>
							</a>
						</div>
					</div>
				</div>
				</div>
				<div class="form-group mb-0 text-right">
					<a href="{{$url.'/forgot-password'}}" class="lost-password text-link">Forgot password?</a>
				</div>
				<div class="form-group">
				{{ Form::input('submit', 'submit', 'submit', array('class'=>'btn btn-primary', 'id'=>'signin' , 'value'=>'Submit'))}}
				</div>
				<div class="form-group">
					<p class="account">Don’t have an account? 
					<a href="{{$url.'/sign-up'}}" class="text-link">Sign Up</a></p>
				</div>
			{{Form::close()}}
			<footer class="login">
				<div class="copyright">Copyright &#169; 2021, All rights reserved.</div>
				<div class="footer-link">
					<a href="{{$url.'/privacy-policy'}}">Privacy Policy</a>
					<a href="{{$url.'/terms-of-services'}}">Terms of Service</a>
				</div>
			</footer>
		</article>
		<div class="clearfix"></div>
	</div>
</section><!-- login-page End -->
@endsection