@extends('layouts.Vendor.vendorDatagrid')
@section('content')

        <div class="container dashboard-page">
            <div class="row">
                <div class="col column-1">
                    <div class="time">
                    @php
                    date_default_timezone_set("Africa/Accra");
                    echo date("h:i a");
                    @endphp
                    </div>
                    <!-- <div class="status rstOnOffLine"><i class="icons switeh-icon"></i> Online</div> -->
                    <div class="status">
                   @if(Auth::guard('restaurant')->user()->is_active)
                        <label class="switch rstOnOffLine">
                          <input type="checkbox" checked>
                          <span class="slider round"></span>
                        </label>
                    Online
                    @else
                    <label class="switch rstOnOffLine">
                          <input type="checkbox">
                          <span class="slider round"></span>
                        </label>
                    Offline
                    @endif
                    </div>

                </div>
            </div><!-- Row end -->
            <div class="row page-heading pt-0">
                <div class="col">
                    <h1 class="page-title">Dashboard</h1>
                </div>
            </div><!-- Row end -->
            <div class="row ">
                <div class="col card-section">


                    <a href="{{env('VENDOR_URL').'/order'}}" class="card-box order">
                      <div class="cnt">
                            <div class="title">Orders</div>
                            <strong>{{isset($ordersCount)? $ordersCount: 0 }}</strong>
                        </div>
                        <div class="icon">
                            <span class="circle"><i class="icons order-icon"></i></span>
                        </div>
                     </a>


                    <a href="{{env('VENDOR_URL').'/menu'}}" class="card-box items">
                        <div class="cnt">
                            <div class="title">Menu Items</div>
                            <strong>{{isset($menuItemsCount)? $menuItemsCount: 0 }}</strong>
                        </div>
                        <div class="icon">
                            <span class="circle"><i class="icons item-icon"></i></span>
                        </div>
                    </a>

                    <div class="card-box revenue">
                        <div class="cnt">
                            <div class="title">Total Revenue</div>
                            <strong><i class="symble-icon">{{config('admin.constants.CURRENCY')}}</i>
                               {{isset($revenueCount->total_revenue)? $revenueCount->total_revenue: 0 }}
                           </strong>
                        </div>
                        <div class="icon">
                            <span class="circle"><i class="icons revenue-icon"></i></span>
                        </div>
                    </div>
                </div>
            </div><!-- Row end -->
            <div class="border-box gray-bg pb-0">
                <div class="row">
                    <div class="col">
                        <div class="page-subtitle">
                            <h2>Today’s Completed Orders</h2>
                            <a href="{{ Url('/securerestaurant/order') }}" class="view-order"> View All Orders
                                <i class="icons arrow-yellow"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row">
                    @if(isset($orderDetails[0]))
                     <div class="col">
                                <div class="order-complete">
                                    @foreach($orderDetails as $value)
                                    <div class="white-box">
                                        <div class="order-id">
                                            <strong>
                                                <a href="{{ env('VENDOR_URL').'/order/'.\Crypt::encryptString($value->id) }}">#{{$value->id}}</a></strong>
                                            @php
                                            date_default_timezone_set("Africa/Accra");
                                            echo date_format($value->created_at,"d M, h:i a");
                                            @endphp
                                        </div>
                                        <div class="order-amount">
                                            Order Amount
                                            <strong class="amount"><i class="">{{config('admin.constants.CURRENCY')}}</i>
                                                <!-- {{ number_format(($value->sub_total + $value->tax), 2, '.', '')}} -->

                                                {{ number_format(($value->sub_total), 2, '.', '')}}

                                            </strong>
                                        </div>
                                        <div class="completed">
                                            <span class="green-btn">Completed</span>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                    @else
                    <div class="col no-order">
                        <div class="cnt">
                            <i class="icons no-order-icon"></i>
                            There is no order has been completed today
                        </div>
                    </div>
                    @endif
                </div>
            </div><!-- border-box -->
        </div>
<!-- /.content-wrapper -->
@endsection
