@extends('layouts.Vendor.vendorDatagrid')
@section('content')
    <div class="container my-order">
        <div class="row page-heading">
            <div class="col">
                <h1 class="page-title pb-0">Manage Transactions</h1>
            </div>
            <div class="col align-right">
                <span class="red">Pending Amount : {{ config('admin.constants.CURRENCY') }}
                    {{ !empty($paymentSummary[0]) ? $paymentSummary[0] : 0 }}
                </span>
                <span class="green">Paid Amount : {{ config('admin.constants.CURRENCY') }}
                    {{ !empty($paymentSummary[1]) ? $paymentSummary[1] : 0 }}</span>
            </div>
            {{-- <div class="clearfix"></div> --}}
        </div><!-- Row end -->
        <div class="row transaction_row">
            {{ Form::open(['url' => $url, 'method' => 'get']) }}
            <div class="search-col">
                <div class="col">
                    {{ Form::date('start_date', Request::get('start_date'), ['placeholder' => 'Start Date', 'class' => 'form-control']) }}
                </div>

                <div class="col">
                    {{ Form::date('end_date', Request::get('end_date'), ['placeholder' => 'End  Date', 'class' => 'form-control']) }}
                </div>
                <div class="col search-box">
                    <i class="icons search-icon"></i>
                    <input type="search" name="search" value="{{ Request::get('search') }}" placeholder="Order ID / Name">
                    <input type="submit" value="Go">
                </div>
                <div class="col">
                    <a href="{{ $url }}" class="reset-btn">Reset</a>
                </div>
            </div>
            {{ Form::close() }}
        </div>
        <div class="responsive-table">
            <table>
                <thead>
                    <tr>
                        <th>Order Date</th>
                        <th>Order ID</th>
                        <th>Customer Name</th>
                        <th>Amount</th>
                        <th>Commision</th>
                        <th>Status</th>
                        <th>Payment Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($list as $data)
                        <tr>
                            <td data-title="Order Date">
                                {{ \Carbon\Carbon::parse($data->created_at)->isoFormat('D MMMM YYYY h:mm a') }}</td>
                            <td data-title="Order ID">
                                <strong>
                                    <a
                                        href="{{ env('VENDOR_URL') . '/order/' . \Crypt::encryptString($data->id) }}">#{{ $data->id }}</a>
                                </strong>
                            </td>
                            <td data-title="Customer Name">{{ $data->firstname . ' ' . $data->lastname }}</td>
                            <td data-title="Amount">{{ config('admin.constants.CURRENCY') }} {{ $data->sub_total- $data->commission  }}
                            </td>
                            <td data-title="Commision">{{ config('admin.constants.CURRENCY') }} {{  $data->commission	 }}
                            </td>
                            <td data-title="Status">{{ $data->orderStatus->name }}</td>
                            <td data-title="Payment Status">{{ $data->vendor_payment_status == 1 ? 'Paid' : 'Un-Paid' }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5">No Orders</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <!-- paginate -->
        {{ $list->links('layouts.Vendor.pagination') }}
        <!-- paginate -->
    </div>


    <script type="text/javascript">
        //Tab
        if (screen.width <= 900) {
            jQuery(function() {
                jQuery(".showSingle").click(function() {
                    jQuery(".showSingle").removeClass("active");
                    jQuery(this).addClass("active");
                    jQuery(".targetDiv").hide();
                    var rel = $(this).attr("rel")
                    jQuery("#" + rel).show();
                });
                jQuery("#first-anchor").trigger("click");
            });
        }
        window.onresize = function() {
            location.reload();
        }
    </script>
@endsection
