@extends('layouts.Vendor.vendorDatagrid')
@section('content')
<div class="container edit-profile">
    <div class="row page-heading">
        <div class="col">
            <h1 class="page-title">Edit Restaurant Profile</h1>
        </div>
    </div>
    <div class="border-box">
        {!! Form::open(['route' => [$controllerUri.'.update',\Crypt::encryptString($profileData->id)], 'method' =>
        'PUT', 'id'=>
        $formId, 'files' => true , 'class'=>"form-section edit-form"]) !!}
        <div class="col-lft">
            <div class="form-group">
                <label>Restaurant Name<span class="required">*</span></label>
                {{ Form::text('name', $profileData->name , array('class'=>'form-control required', 'id'=>'name','placeholder' => 'Enter restaurant name', 'maxlength'=>config('admin.constants.restaurant.restaurant_name.maxLength'))) }}

            </div>
            <div class="form-group">
                <label>Restaurant Bio<span class="required">*</span></label>
                {{ Form::textarea('restaurant_bio', $profileData->bio , array('class'=>'form-control required', 'id'=>'bio','placeholder' => 'Enter Restaurant Bio' , 'maxlength'=>config('admin.constants.restaurant.restaurant_bio.maxLength') )) }}
            </div>

            <div class="form-group">
                <label>Restaurant type<span class="required">*</span></label>
                <div class="restaurant-type-row">
                    <div class="custom-checkbox">
                        <label>
                            <input type="checkbox" class="restaurantTypes" name="type[local]" value="1" {{ ($profileData->resturent_type_local == 1  ? 'checked' : '') }}> 
                            <span>Local</span>
                        </label>
                    </div>

                    <div class="custom-checkbox">
                        <label>
                            <input type="checkbox" class="restaurantTypes" name="type[continental]" value="1" {{ ($profileData->resturent_type_continental==1 ? 'checked' : '') }}> 
                            <span>Continental</span>
                        </label>
                    </div>
                    <div class="custom-checkbox">
                        <label>
                            <input type="checkbox" class="restaurantTypes" name="type[groceries]" value="1" {{ ($profileData->resturent_type_groceries==1 ? 'checked' : '') }}> 
                            <span>Groceries</span>
                        </label>
                    </div>
                </div>
                <div id="restaurant-type-error">	</div>
            </div>


            <div class="form-group">
                <label>Email<span class="required">*</span></label>
                {{ Form::email('', $profileData->user->email , array('class'=>'form-control required', 'id'=>'email','placeholder' => 'Enter email address' , 'disabled'=>'disabled')) }}
            </div>


            <div class="form-group">
                <label>Delivery Time (In mins)<span class="required">*</span></label>
                {{ Form::text('delivery_time', $profileData->delivery_time , array('class'=>'form-control required', 'id'=>'delivery_time','placeholder' => '15-30')) }}
            </div>
            <div class="form-group">
                <label>Address1<span class="required">*</span></label>
                <div class="relative-box">
                    {{ Form::text('address1', $profileData->address1, array('class'=>'form-control required', 'autocomplete'=>'off', 'id'=>'address1','placeholder' => 'Enter address', 'onchange' => "return trim(this)" , 'onFocus'=>'initializeAutocomplete()')) }}
                    <div class="icons map-icon"></div>
                </div>
            </div>
            <div class="form-group">
                <label>Address2<span class="required">*</span></label>
                {{ Form::text('address2', $profileData->address2, array('class'=>'form-control required', 'autocomplete'=>'off', 'id'=>'address2','placeholder' => 'Street No. 175/4, Near City Light', 'onchange' => "return trim(this)")) }}
            </div>
            <div class="form-group">
                <label>City<span class="required">*</span></label>
                {{ Form::text('locality', $profileData->city, array('class'=>'form-control required', 'id'=>'locality','placeholder' => 'City', 'onchange' => "return trim(this)")) }}
            </div>
            <div class="row plr-8">
                <div class="col-lg-7 col-md-7 plr-8">
                    <div class="form-group">
                        <label>region<span class="required">*</span></label>
                        {{ Form::text('country', $profileData->region, array('class'=>'form-control required', 'id'=>'country','placeholder' => 'Region', 'onchange' => "return trim(this)")) }}
                    </div>
                </div>
                <div class="col-lg-5 col-md-5 plr-8">
                    <div class="form-group">
                        <label>Zip code<span class="required"></span></label>
                        {{ Form::number('postcode', $profileData->zipcode, array('class'=>'form-control', 'id'=>'postcode', 'placeholder' => 'Zip code')) }}
                    </div>
                </div>
            </div>
            {{ Form::hidden('latitude' , $profileData->latitude , array('id'=>'latitude')) }}
            {{ Form::hidden('longitude' , $profileData->longitude , array('id'=>'longitude')) }}

            <div class="group-btn justify-start">
                <a  href="{{ env('VENDOR_URL').'/profile' }}"   class="btn btn-cancel">Cancel</a>
                <input type="submit" value="submit" id="restaurantEditProfile" class="btn btn-primary">
            </div>
        </div>

        <div class="col-rgt">
            <div class="edit-image">
                @if(!empty($userAvatar))
                <img id="imagePreview" src="{{ $userAvatar }}">
                @else
                <img id="imagePreview" src="{{ config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE') }}" alt="{{ $profileData->name }}" title="{{ $profileData->name }}">
                @endif
                {{ Form::file('avatar', ['id' => 'upload-photo' , 'class'=>'file-upload' , 'accept'=>"image/*"]) }}
                {{-- <input type="file" class="file-upload" id="upload-photo" name="files[]" multiple="multiple"
                    accept="image/*" /> --}}
                <label id="upload-photo-label" class="file-upload" for="upload-photo">Change Photo</label>
            </div>
            <div id="img-error" class="error"></div>
        </div>
        {{Form::close()}}
    </div><!-- border-box -->
</div>


<script> 
$(document).ready(function(){

  /** 
   * author : jaidev
   * email : jaidev@nmgtechnologies.com
   * desc : validate edit restaurant form elements
   */

   $.validator.addMethod('filesize', function (value, element, param) {
        // alert(element.files[0].size);
        // alert(param);
            return this.optional(element) || (element.files[0].size <= param)
        }, 'Image must be less than 5 MB');

   $("#editRestaurant").validate({
    rules: {
        name: {
            required:true,
            minlength: "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
            maxlength: "{{ config('admin.constants.restaurant.restaurant_name.maxLength') }}",
        },
        restaurant_bio: {
            minlength: "{{ config('admin.constants.restaurant.restaurant_bio.minLength') }}",
            maxlength: "{{ config('admin.constants.restaurant.restaurant_bio.maxLength') }}",
        },
        delivery_time: {
            required: true,
            regex:"^[0-6][0-9]-[0-6][0-9]$"
        },
        address1: { 
            required:true,
            minlength: "{{ config('admin.constants.restaurant.restaurant_name.minLength') }}",
        },
        address2: { 
            required:true,
        },
        locality: {
            required:true,
        },
        country :{
            required : true,
        },
        avatar: {
            filesize: 5242880,
        }
        
    },
    messages: {
        name: {
            required: "{{__('admin/validation/restaurant.restaurant_name.required')}}",
            minlength: "{{__('admin/validation/restaurant.restaurant_name.min')}}",
            maxlength: "{{__('admin/validation/restaurant.restaurant_name.max')}}",
        },
        restaurant_bio: {
            code: "{{__('admin/validation/restaurant.restaurant_bio.code')}}",
            required: "{{__('admin/validation/restaurant.restaurant_bio.required')}}",
            string: "{{__('admin/validation/restaurant.restaurant_bio.string')}}",
            minlength: "{{__('admin/validation/restaurant.restaurant_bio.min')}}",
            maxlength: "{{__('admin/validation/restaurant.restaurant_bio.max')}}",
        },
        delivery_time: {
            required: "{{__('admin/validation/restaurant.delivery_time.required')}}",
            regex:"The delivery time should enter in range format"
        },
        
        address1: {
            required: "{{__('admin/validation/restaurant.restaurant_address.required')}}",
        },
        address2: {
            required: "{{__('admin/validation/restaurant.restaurant_address2.required')}}",
        },
        locality: {
            required: "{{__('admin/validation/restaurant.city.required')}}",
        },
        country: {  
            required: "{{__('admin/validation/restaurant.region.required')}}",
        },
        
    },
  
    submitHandler: function(form) {
        $(".validation-error").html('');
        form.submit();
    }
  });

});
</script>

<script defer src="{{ asset('resources/assets/js/address.js') }}"></script>
<!-- Async script executes immediately and must be after any DOM elements used in callback. -->
<!-- <script
      src="https://maps.googleapis.com/maps/api/js?key={{ env('ADDRESS_API_KEY')}}&callback=initAutocomplete&libraries=places&v=weekly"
      async
    ></script> -->

<script src="//maps.googleapis.com/maps/api/js?libraries=places&key={{ env('ADDRESS_API_KEY')}}"></script>
<script>
	$(document).on('click' , '.restaurantTypes' , function(){
		var checked = jQuery(".restaurantTypes:checked").length;
		if(checked > 0){
			$('#restaurant-type-error').html('');
		}
		else{
			$('#restaurant-type-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The restaurant type field is required</label>');
        $("#restaurant-type-error").focus();
		}
	});




	$(document).on('keyup' , '#address1' , function(){
		var length = jQuery("#address1").val().trim().length;
		if(length > 0){
			$('#address-web-error').html('');
		}
		else{
			$('#address-web-error').html('<label class="error-validation" style="color: #ff0000; text-transform: none; font-size: 14px;">The Address1 field is required for autosuggestion.</label>');
		}
	});
</script>
@endsection