@extends('layouts.Vendor.vendorDatagrid')
@section('content')
<div class="container">
    <div class="row page-heading">
        <div class="col">
            <h1 class="page-title">Change Password</h1>
        </div>
    </div><!-- Row end -->
    <div class="border-box contact-form">
        {!! Form::open(['url' => env('VENDOR_URL').'/vendor-update-password', 'method'=>'PUT', 'id'=> $formId, 'files'
        => true
        , 'class'=>"form-section edit-form"]) !!}
        <div class="form-group">
            <label>Old Password<span class="required">*</span></label>
            {{ Form::input('password' , 'password', null , array('class'=>'form-control required', 'id'=>'old_password','placeholder' => 'Enter your old password')) }}
            <span id="password_error" class="validation-error"></span>
        </div>
        <div class="form-group">
            <label>New Password<span class="required">*</span></label>
            {{ Form::input('password' ,'new_password', null , array('class'=>'form-control required', 'id'=>'new_password','placeholder' => 'Enter your new password')) }}
            <span id="new_password_error" class="validation-error"></span>
        </div>

        <div class="form-group">
            <label>Confirm New Password<span class="required">*</span></label>
            {{ Form::input('password' ,'new_password_confirmation', null , array('class'=>'form-control required', 'id'=>'confirm_password','placeholder' => 'Re-enter your new password')) }}
            <span id="new_password_confirmation_error" class="validation-error"></span>
        </div>
        <div class="group-btn justify-start">
            <button type="Submit" class="btn btn-primary" id="submit-btn">Submit</button>
            <!-- <a href="#password-changed" data-toggle="modal" data-keyboard="true" data-keyboard="true"
                class="btn btn-primary mob-100">
                Submit
            </a> -->
        </div>
        </form>

    </div><!-- border-box -->
</div>

<!------ Add Comment modal Popup ------>
<div class="modal fade" id="password-changed" tabindex='-1'>
    <div class="vertical-alignment-helper">
        <div class="modal-dialog vertical-align-center">
            <div class="modal-content success-model">
                <div class="modal-body">
                    <div class="yes-icon"><span></span></div>
                    <h3>Password Changed!</h3>
                    <p>Your password has been changed successfully!</p>
                    <p>You have been logged out. Please login again!</p>
                    <a href="{{ env('VENDOR_URL') }}" class="btn btn-primary">LOGIN</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection