@extends('layouts.Vendor.vendorDatagrid')
@section('content')
    <div class="container order-detail">
        <div class="row page-heading">
            <div class="col">
                <h1 class="page-title pb-0">Order Detail</h1>
            </div>
        </div>
        <div class="border-box">
            <div class="gray-box">
                <div class="col-lft">
                    <div class="order-id">#{{ $orderData->id }}</div>
                    <div class="time">
                        {{ \Carbon\Carbon::parse($orderData->created_at)->isoFormat('D MMMM YYYY') }} <span>at
                            {{ \Carbon\Carbon::parse($orderData->created_at)->isoFormat('h:mm a') }}</span></div>
                </div>
                <div class="col-rgt">
                    <div class="status">Order Status: <strong
                            class="text-orange">{{ $orderData->orderStatus->name }}</strong></div>
                    <div class="status-btn">

                        @if ($orderData->order_status_id == config('admin.constants.ORDER_STATUS_PENDING'))
                            <a href="{{ env('VENDOR_URL') . '/order/reject/' . \Crypt::encryptString($orderData->id) }}"
                                class="btn white-btn">Reject Order</a>
                            <a href="{{ env('VENDOR_URL') . '/order/approve/' . \Crypt::encryptString($orderData->id) }}"
                                class="btn btn-primary">Accept order</a>
                        @elseif ($orderData->order_status_id == config('admin.constants.ORDER_STATUS_IN_PREP'))
                            <a href="{{ env('VENDOR_URL') . '/order/cancel/' . \Crypt::encryptString($orderData->id) }}"
                                class="btn btn-danger">Cancel Order</a>
                            @if (!empty($assignmentData))
                                <a href="{{ env('VENDOR_URL') . '/order/handover/' . \Crypt::encryptString($orderData->id) }}"
                                    class="btn btn-primary {{ @$assignmentData->status == 2 ? '' : 'disabled' }}">Handover
                                    to rider</a>

                                <a href="{{ env('VENDOR_URL') . '/order/re-assign-rider/' . \Crypt::encryptString($orderData->id) }}"
                                    class="btn btn-warning {{ @$assignmentData->status == 2 ? '' : 'disabled' }}">Re-Assign
                                    Rider</a>
                            @endif
                        @elseif ($orderData->order_status_id == config('admin.constants.ORDER_STATUS_ON_THE_WAY'))
                            @if (!empty($assignmentData) && $assignmentData->status == 3)
                                <a href="{{ env('VENDOR_URL') . '/order/re-assign-rider/' . \Crypt::encryptString($orderData->id) }}"
                                    class="btn btn-warning {{ @$assignmentData->status == 3 ? '' : 'disabled' }}">Re-Assign
                                    Rider</a>
                            @endif
                        @else
                        @endif
                    </div>
                </div>
            </div>
            <ul class="my-order-list">
                @forelse ($orderData->orderItem as $item)
                    <li>
                        <figure>
                            @if (!empty($item->itemDetail->image))
                                <img src="{{ $item->itemDetail->image }}" alt="{{ $item->itemDetail->name }}"
                                    title="{{ $item->itemDetail->name }}">
                            @else
                                <img src="{{ config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE') }}"
                                    alt="{{ $item->itemDetail->name }}" title="{{ $item->itemDetail->name }}">
                            @endif

                        </figure>
                        <div class="order-description">
                            <div class="order-category">
                                <div class="column">
                                    <span>ITEM NAME</span>
                                    {{ $item->itemDetail->name }}
                                </div>
                                <div class="column category">
                                    <span>Category</span>
                                    {{ $item->itemDetail->foodCategory->name }}
                                </div>
                                <div class="column price">
                                    {{ $item->item_qty }} x
                                    <div class="amount">
                                        <i class="">{{ config('admin.constants.CURRENCY') }}</i>
                                        {{ $item->item_price }}
                                    </div>
                                </div>
                            </div>
                            <div class="delivery-note">
                                <span>Delivery note</span>
                                <p>{{ $orderData->delivery_note }}</p>
                            </div>
                        </div>
                    </li>
                @empty
                    <p>No item found</p>
                @endforelse

            </ul>

            @if ($orderData->delivery_person_id > 0)
                <div class="customer-details">
                    <div class="address-box">
                        <div class="title">Customer Details</div>
                        <p><strong>NAME</strong> {{ $orderData->firstname . ' ' . $orderData->lastname }}</p>
                        <p><strong>CONTACT NUMBER</strong> +233 {{ $orderData->phone_number }}</p>
                        <p><strong>ADDRESS</strong> {{ $orderData->address1 }}<br>{{ $orderData->city }} ,
                            {{ $orderData->country }}</p>
                    </div>
                    @if (!empty($assignmentData) && $assignmentData->status == 2)
                        <div class="address-box">
                            <div class="title">Rider Details</div>
                            <p><strong>NAME</strong>
                                {{ $deliveryPersonData->user->first_name . ' ' . $deliveryPersonData->user->last_name }}
                            </p>
                            <p><strong>Age</strong> {{ $deliveryPersonData->age }}</p>
                            <p><strong>Contact number</strong> +233 {{ $deliveryPersonData->user->phone_number }}</p>
                        </div>
                    @else
                        <div class="address-box order-not-accepted">
                            <div class="title">Rider Details</div>
                            <p>The order has been not accepted yet by rider</p>
                        </div>
                    @endif


                </div>
            @else
                <div class="customer-details">
                    <div class="address-box w-100">
                        <div class="title">Customer Details</div>
                        <p><strong>NAME</strong> {{ $orderData->firstname . ' ' . $orderData->lastname }}</p>
                        <p><strong>CONTACT NUMBER</strong> +233 {{ $orderData->phone_number }}</p>
                        <p><strong>ADDRESS</strong> {{ $orderData->address1 }}<br>{{ $orderData->city }} ,
                            {{ $orderData->country }}</p>
                    </div>
                </div>
            @endif

            <div class="total-amount">
                Sub Total:
                <div class="price"><i class="">{{ config('admin.constants.CURRENCY') }}</i>
                    {{ $orderData->sub_total }}</div>

            </div>
            <div class="total-amount">
                BMF Commission:
                <div class="price"><i class="">{{ config('admin.constants.CURRENCY') }}</i>
                    {{ $orderData->commission }}</div>

            </div>
            <div class="total-amount">
                Restaurant Revenue:
                <div class="price"><i class="">{{ config('admin.constants.CURRENCY') }}</i>
                    {{ $orderData->sub_total - $orderData->commission }}</div>

            </div>
        </div><!-- border-box -->
    </div>



@endsection
