@extends('layouts.Vendor.vendorDatagrid')
@section('content')
    <div class="container my-order">
        <div class="row page-heading">
            <div class="col">
                <h1 class="page-title pb-0">Order Listing</h1>
            </div>
            {{ Form::open(['url' => $url, 'method' => 'get']) }}
            <div class="col search-col">
                <div class="search-box">
                    <i class="icons search-icon"></i>
                    <input type="search" name="search" value="{{ Request::get('search') }}" placeholder="Search">
                    <input type="submit" value="Go">
                </div>
            </div>
            {{ Form::close() }}
        </div><!-- Row end -->
        <div class="mob-tab">
            <ul>
                <li><a href="javascript:void(0)" class="showSingle active" id="first-anchor" rel="div1">New Orders</a></li>
                <li><a href="javascript:void(0)" class="showSingle" rel="div2">Punched Orders</a></li>
            </ul>
        </div>
        <div class="order-list">
            <div class="border-box targetDiv" id="div1">
                <div class="heading">
                    <h2>New Orders <span class="count">({{ $pendingList->total() }})</span>
                </div>
                @forelse ($pendingList as $order)
                    <div class="white-box">
                        <div class="column first">
                            <strong><a
                                    href="{{ env('VENDOR_URL') . '/order/' . \Crypt::encryptString($order->id) }}">#{{ $order->id }}</a></strong>
                            @php
                                date_default_timezone_set('Africa/Accra');
                                echo date_format($order->created_at, 'd M, h:i a');
                            @endphp
                        </div>
                        <div class="column second">
                            Order Amount
                            <strong class="amount"><i
                                    class="">{{ config('admin.constants.CURRENCY') }}</i>
                                {{ $order->sub_total }}</strong>
                        </div>
                        <div class="column third">
                            <a href="{{ env('VENDOR_URL') . '/order/approve/' . \Crypt::encryptString($order->id) }}"
                                class="order-btn accept"><span>Accept Order</span></a>
                            <a href="{{ env('VENDOR_URL') . '/order/reject/' . \Crypt::encryptString($order->id) }}"
                                class="order-btn reject"><span>Reject Order</span></a>

                        </div>
                    </div>
                @empty
                    <p>No orders</p>
                @endforelse

                <!-- paginate -->
                {{ $pendingList->appends(['type' => 'pending'])->links('layouts.Vendor.pagination') }}
                <!-- paginate -->
            </div><!-- border-box -->
            <div class="border-box targetDiv" id="div2">
                <div class="heading">
                    <h2>Punched Orders <span class="count">({{ $punchedList->total() }})</span></h2>
                    <div class="filter">
                        <div class="select-box">
                            <select class="selectpicker order-filter form-control" data-dropup-auto="false"
                                data-url="{{ $url }}">
                                <option>Filter</option>
                                @foreach ($orderStatusList as $os)
                                    <option value='{{ $os->id }}'
                                        {{ $os->id == request()->status ? 'selected' : '' }}>{{ $os->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                @forelse ($punchedList as $order)
                    <div class="white-box">
                        <div class="column first">
                            <strong><a
                                    href="{{ env('VENDOR_URL') . '/order/' . \Crypt::encryptString($order->id) }}">#{{ $order->id }}</a></strong>
                            @php
                                date_default_timezone_set('Africa/Accra');
                                echo date_format($order->created_at, 'd M, h:i a');
                            @endphp
                        </div>
                        <div class="column second">
                            Order Amount
                            <strong class="amount"><i
                                    class="">{{ config('admin.constants.CURRENCY') }}</i>
                                {{ $order->sub_total }}</strong>
                        </div>
                        <div class="column third">
                            <a href="{{ env('VENDOR_URL') . '/order/' . \Crypt::encryptString($order->id) }}"
                                class="order-btn {{ (new \app\Helpers\OrderTypeHelper())->orderStatus($order->orderStatus->id) }}">
                                <span>{{ $order->orderStatus->name }}</span>
                            </a>
                        </div>
                    </div>
                @empty
                    <p>No orders</p>
                @endforelse
                {{ $punchedList->appends(['type' => 'punched'])->links('layouts.Vendor.pagination') }}
                <!-- paginate -->

            </div><!-- border-box -->
        </div><!-- order-list -->
    </div>


    <script type="text/javascript">
        //Tab
        if (screen.width <= 900) {
            jQuery(function() {
                jQuery(".showSingle").click(function() {
                    jQuery(".showSingle").removeClass("active");
                    jQuery(this).addClass("active");
                    jQuery(".targetDiv").hide();
                    var rel = $(this).attr("rel")
                    jQuery("#" + rel).show();
                });
                jQuery("#first-anchor").trigger("click");
            });
        }
        window.onresize = function() {
            location.reload();
        }
    </script>
@endsection
