@extends('layouts.Vendor.vendorDatagrid')
@section('content')
<div class="container">					
    <div class="row page-heading">
        <div class="col">
            <h1 class="page-title">Notification <span class="count">({{ $notificationList->total() }})</span></h1>
        </div>
    </div><!-- Row end -->
    <div class="responsive-table table-border">
        <table>
            <thead>
                <tr>
                    <td class="inner-table" colspan="3">
                        <table>
                            <tbody><tr>
                                <td class="date">DATE</td>
                                <td class="title">TITLE</td>
                                <td class="description">DESCRIPTION</td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>
            </thead>					
            <tbody>
                <tr>
                    <td class="inner-table" colspan="3">
                        <table>
                            <tbody>
                            @forelse ($notificationList as $notification )
                            <tr>
                                <td data-title="Date" class="date">
                                    {{ \Carbon\Carbon::parse($notification->created_at)->format('M d, Y h:i a') }}
                                    </td>
                                <td data-title="Title" class="title {{ ($notification->is_read == 0 ? 'unread-notification-td' : '') }}" >
                                    <a href="{{ env('VENDOR_URL').'/order/'.\Crypt::encryptString($notification->order_id) }}">
                                    {{ $notification->title }}
                                    </a>
                                
                                </strong></td>
                                <td data-title="Description" class="description {{ ($notification->is_read == 0 ? 'unread-notification-td' : '') }}">{{ $notification->description }}</td>
                            </tr>    
                            @empty
                            <tr>
                                <td>
                                    No Notification   
                                </td>
                            </tr>
                            @endforelse
                            
                        </tbody></table>
                    </td>
                </tr>								
            </tbody>
        </table>							
    </div><!-- esponsive-table -->

    {{ $notificationList->links('layouts.Vendor.pagination') }}
</div>
@endsection
