@extends('layouts.Vendor.vendorDatagrid')
@section('content')
				<div class="container menu-detail">					
					<div class="row page-heading">
						<div class="col-lg-4 col-md-6 col-50">
							<h1 class="page-title pb-0">Menu Detail</h1>
						</div>
						<div class="col-lg-8 col-md-6 col-50">
							<div class="edit-detail">
							@include('elements.vendor.action-link-restaurant-menu', ['row' => $menuData , 'controlType'=>'editHandler'])
							@include('elements.vendor.action-link-restaurant-menu', ['row' => $menuData , 'controlType'=>'deleteButton'])
							@include('elements.vendor.action-link-restaurant-menu', ['row' => $menuData , 'controlType'=>'statusHandler'])
								
							</div>
						</div>
					</div>	
					<div class="border-box">
						<div class="item-detail">
							<div class="col-lft">
								<h2>{{ $menuData->name }}</h2>
								<div class="item-category">{{ $menuData->foodCategory->name }}</div>
							</div>
							<div class="col-rgt">
								<div class="prep-time">Prep Time: <strong> {{ $menuData->prep_time }} Min</strong></div>
								<div class="price"><i class="icons price-icon-small"></i> {{ $menuData->price }}</div>
							</div>
						</div>
						<div class="description">
							<div class="cnt">
								<h3>ITEM DESCRIPTION</h3>
								<p>{{ $menuData->description }}</p>
								<h3>ALLERGY ADVICE</h3>
								<p>{{ $menuData->allergy_advice }} </p>
							</div>
							<div class="item-pic">
								<figure>
									
									@if(!empty($menuData->image))
									<img src="{{ $menuData->image }}" alt="{{ $menuData->name }}" title="{{ $menuData->name }}">
									@else
									<img src="{{ config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE') }}" alt="{{ $menuData->name }}" title="{{ $menuData->name }}">
									@endif
									
								</figure>
							</div>
						</div>
					</div><!-- border-box -->
				</div>
			



@endsection
