@extends('layouts.Vendor.vendorDatagrid')
@section('content')

<div class="container add-item-page">
    <div class="row page-heading">
        <div class="col">
            <h1 class="page-title">Add an Item</h1>
        </div>
    </div>
    <div class="border-box">
        {!! Form::open(['route' => [$controllerUri.'.store'], 'method' => 'POST', 'id'=>
        $formId, 'files' => true , 'class'=>"form-section"]) !!}

        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Choose Item Category<span class="required">*</span></label>
                    <div class="select-box">
                        <select class="selectpicker form-control" data-dropup-auto="false" name="food_category_id"
                            id="food_category_id" value="{{ old('food_category_id') }}" required>
                            <option value="">Select</option>
                            @foreach($foodCatList as $foodCat)
                            <option value='{{ $foodCat->id }}'
                                {{ ($foodCat->id==old('food_category_id') ? 'selected' : '') }}>{{$foodCat->name}}
                            </option>
                            @endforeach
                        </select>
                        @error('food_category_id')
                        <div class="error">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Item Name<span class="required">*</span></label>
                    <input type="text" name="name" id="name" class="form-control character-counter"
                        value="{{ old('name') }}" placeholder="Enter item name" data-counter-div="name-character"
                        maxlength="80">
                    <p class="character" id="name-character">{{ strlen(old('name')) }}/80 characters</p>
                    @error('name')
                    <div class="error">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col-lg-6 col-md-12">
                <div class="form-group">
                    <label>Item Photo</label>
                    <div class="browser-box">
                        <div class="uploader">
                            <input type="file" name="image" size="25" value="{{ old('image') }}" accept="image/*">
                            <div class="fakeFile" contenteditable="false" readonly="true">
                                <p class="text">No file chosen</p>
                                <a href="javascript:void(0)" class="uiBtn browse">Choose File</a>
                            </div>
                        </div>
                    </div>
                    @error('image')
                    <div class="error">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-lg-6 col-md-12">
                <div class="row plr-8">
                    <div class="col-lg-7 col-md-6 plr-8">
                        <div class="form-group">
                            <label>Item Prep Time in Minutes<span class="required">*</span></label>
                            <input type="number" name="prep_time" id="prep_time" class="form-control"
                                placeholder="Enter prep time" value="{{ old('prep_time') }}" maxlength=2  oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);">
                            @error('prep_time')
                            <div class="error">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6 plr-8">
                        <div class="form-group">
                            <label>Price<span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-addon"><i class="price-icon"></i></span>
                                <input class="input-field" type="number" placeholder="Enter price" name="price"
                                    id="price" value="{{ old('price') }}">
                                @error('price')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Allergy Advice<span class="required"></span></label>
                    <textarea class="form-control character-counter" name="allergy_advice" id="allergy_advice"
                        placeholder="Enter allergy advice" data-counter-div="allergy-advice-character"
                        maxlength="100">{{ old('allergy_advice') }}</textarea>
                    <p class="character" id="allergy-advice-character">{{ strlen(old('allergy_advice')) }}/100
                        characters</p>
                    @error('allergy_advice')
                    <div class="error">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-lg-6 col-md-6">
                <div class="form-group">
                    <label>Item Description<span class="required">*</span></label>
                    <textarea class="form-control character-counter" name="description" id="description"
                        placeholder="Enter item description" data-counter-div="desc-character"
                        maxlength="100">{{ old('description') }}</textarea>
                    <p class="character" id="desc-character">{{ strlen(old('description')) }}/100 characters</p>
                    @error('description')
                    <div class="error">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col">
                <div class="group-btn">
                    <a  href="{{ env('VENDOR_URL').'/menu' }}"   class="btn btn-cancel">Cancel</a>
                    {{ Form::submit('Submit', array('class'=>'btn btn-primary')) }}
                </div>
            </div>
        </div><!-- row end -->
        {{Form::close()}}
    </div><!-- border-box -->
</div>

<script>
    $(function(){
        $.validator.addMethod('filesize', function (value, element, param) {
            return this.optional(element) || (element.files[0].size <= param)
        }, 'File size must be less than 5 MB');

        $("#createRestaurantMenuItem").validate({
            rules: {
                    food_category_id: {
                    required: true,
                },
                name: {
                    required: true,
                    maxlength: {{ config('admin.constants.restaurant-menu.name.maxLength') }},
                    minlength: {{ config('admin.constants.restaurant-menu.name.minLength') }}
                },
                prep_time:{
                    required:true,
                    minlength: {{config('admin.constants.restaurant-menu.prep_time.minLength')}},
                    maxlength : {{config('admin.constants.restaurant-menu.prep_time.maxLength')}}
                },
                description : {
                    required : true,
                    minlength: {{config('admin.constants.restaurant-menu.description.minLength')}},
                    maxlength : {{config('admin.constants.restaurant-menu.description.maxLength')}}
                },
                price : {
                    required : true,
                    minlength: {{config('admin.constants.restaurant-menu.price.minLength')}},
                },
                image: {
                    filesize: 5242880,
                }
            },
            messages: {
                food_category_id: {
                    required: "Please choose food category",
                },
                name: {
                    required: "{{ __('admin/validation/restaurant_menu.name.required') }}",
                    maxlength: "{{ __('admin/validation/restaurant_menu.name.max') }}",
                    minlength: "{{ __('admin/validation/restaurant_menu.name.min') }}"
                },
                prep_time:{
                    required:" {{ __('admin/validation/restaurant_menu.prep_time.required') }}",
                    minlength: "{{ __('admin/validation/restaurant_menu.prep_time.min') }}",
                    maxlength: "{{ __('admin/validation/restaurant_menu.prep_time.max') }}",
                    
                },
                description : {
                    required : "{{ __('admin/validation/restaurant_menu.description.required') }}",
                    minlength: "{{ __('admin/validation/restaurant_menu.description.min') }}",
                    maxlength : "{{ __('admin/validation/restaurant_menu.description.max') }}",
                },
                price : {
                    required : "{{ __('admin/validation/restaurant_menu.price.required') }}",
                    minlength: "{{ __('admin/validation/restaurant_menu.price.min') }}",
                    maxlength : "{{ __('admin/validation/restaurant_menu.price.max') }}",
                },
                

            },
            errorPlacement:function(error, element){
				
				if(element.attr("name") == "food_category_id" || element.attr("name") == "price")
                    error.insertAfter(element.parent());
                else if(element.attr("name") == "image")
                    error.insertAfter(element.parent().parent());
                else
                    error.insertAfter(element);
			},
            submitHandler: function(form) {
                form.submit();
           
            }
        });
    });
</script>

@endsection