@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                {{ Form::open(['method' => 'get', 'class' => 'form-horizontal']) }}
                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-3">
                                        {{ Form::text('search', app('request')->input('search'), ['placeholder' => 'Order ID', 'class' => 'form-control']) }}
                                    </div>
                                    <div class="col-sm-3">
                                        {{ Form::select('restaurant', $restaurantList, app('request')->input('restaurant'), ['placeholder' => 'Select Restaurant', 'class' => 'form-control select2']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::select('payment_status', [0 => 'Un-Paid', 1 => 'Paid'], app('request')->input('payment_status'), ['placeholder' => 'Payment Status', 'class' => 'form-control']) }}
                                    </div>
                                    <div class="col-sm-2">
                                        {{ Form::date('start_date', app('request')->input('start_date'), ['placeholder' => 'End Date', 'class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::date('end_date', app('request')->input('end_date'), ['placeholder' => 'End Date', 'class' => 'form-control']) }}
                                    </div>

                                    <br><br>
                                    <div class="col-sm-2">
                                        {{ Form::submit('Search', ['class' => 'btn btn-success']) }}
                                        <a href="{{ $url }}" class="btn btn-default">Reset</a>
                                    </div>

                                    <div class="col-sm-2 pull-right">
                                        <button type="button" class="btn btn-primary"
                                            onclick="restaurantAmountPayHandler()">Pay Now</button>
                                    </div>
                                </div>

                                {{ Form::close() }}
                            </div>
                        </div>
                        <div class="box-body">
                            @if (count($orderList) > 0)
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <input type="checkbox" id="selectAllCheckbox" value="">
                                                    Select all
                                                </th>
                                                <th width="15%">Order ID</th>
                                                <th>Restaurant Name</th>
                                                <th>Customer Name</th>
                                                <th>Order Amount</th>
                                                <th>Commission</th>
                                                <th>Tax</th>
                                                <th>Amount To Pay</th>
                                                <th>Revenue</th>
                                                <th>Order Date</th>
                                                <th>Payment Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $srNo = $limit * ($page - 1) + 1;
                                            @endphp
                                            @foreach ($orderList as $order)
                                                <tr>
                                                    <td>
                                                        <div class="td-count-checkbox">

                                                            <span>{{ $srNo++ }}</span>
                                                            @if ($order->vendor_payment_status == 0)
                                                                <input type="checkbox"
                                                                    class="selectAll orderCheckBox checkbox"
                                                                    value="{{ $order->id }}">
                                                            @endif
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <a href="{{ url($orderUrl . '/' . \Crypt::encryptString($order->id)) }}"
                                                            title="View" target="_blank">
                                                            {{ $order->id }}
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="{{ url($restaurantUrl . '/' . \Crypt::encryptString($order->restaurant_id)) }}"
                                                            class="various" data-fancybox-type="iframe" title="View">
                                                            {{ $order->restaurant->name }}
                                                        </a>
                                                    </td>


                                                    <td>
                                                        <a href="{{ url($customerUrl . '/' . \Crypt::encryptString($order->user_id)) }}"
                                                            class="various" data-fancybox-type="iframe" title="View">
                                                            {{ $order->firstname . ' ' . $order->lastname }}
                                                        </a>
                                                    </td>

                                                    <td>{{ $order->total_amount }}</td>
                                                    <td>{{ $order->commission }}</td>
                                                    <td>{{ $order->tax }}</td>
                                                    <td>{{ $order->sub_total - $order->commission }}</td>
                                                    <td>{{ $order->revenue_on_delivery_charge }}</td>

                                                    <td>{{ \Carbon\Carbon::parse($order->created_at)->format('d-M-Y') }}
                                                    </td>
                                                    <td>{{ $order->vendor_payment_status == 1 ? 'Paid' : 'Un-Paid' }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            {{ config('flash_msg.NoRecordFound') }}</td>
                                    </tr>
                                </table>
                            @endif
                        </div>
                        @if (count($orderList) > 0)
                            @include('elements.Admin.pagination-link', [
                                'dataList' => $orderList,
                            ])
                        @endif
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
    </script>

@endsection
