@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">

                            </div>
                        </div>
                        <div class="box-body">
                            @if (!empty($TaxSetting))
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th width="15%">Sr.No.</th>
                                                <th width="15%">Service Fee</th>
                                                <th width="15%">Type</th>
                                                <th width="15%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $srNo = $limit * ($page - 1) + 1;
                                            @endphp

                                            <tr>
                                                <td>{{ $srNo++ }}</td>
                                                <td>
                                                    {{ $TaxSetting->value }}
                                                </td>
                                                <td>
                                                    {{ $TaxSetting->symbal }}
                                                </td>
                                                <td class="action-btn">
                                                    <span>
                                                        {!! Form::open(['method' => 'GET', 'route' => [$controllerUri . '.edit', \Crypt::encryptString($TaxSetting->id)]]) !!}

                                                        {!! Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left fa fa-edit', 'title' => 'Edit Tax Setting']) !!}
                                                        {!! Form::close() !!}
                                                    </span>
                                                </td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            {{ config('flash_msg.NoRecordFound') }}</td>
                                    </tr>
                                </table>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
    </script>
@endsection
