@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get','class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Title', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-3">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($staticPageList) > 0)
                        <div class="static_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>S.No.</th>
                                        <th>@sortablelink('title', 'Title')</th>
                                        <th>@sortablelink('slug', 'Slug')</th>
                                        <th>@sortablelink('title', 'Meta Title')</th>

                                        <th class="fourty wordbreak">@sortablelink('content', 'Content')</th>
                                        <th>Last updated</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($staticPageList as $key => $staticPage)
                                    <tr>
                                        <td>{{ ($staticPageList->currentpage()-1) * $staticPageList->perpage() + $key + 1 }}
                                        </td>
                                        <td>
                                        <a href="{{url($url.'/'.\Crypt::encryptString($staticPage->id))}}" class="various"
                                                data-fancybox-type="iframe" title="View">{{ !empty($staticPage->title) ? $staticPage->title : config("admin.constants.EmptyNotation") }}</a>
                                        </td>

                                        <td>
                                            {{ !empty($staticPage->slug) ? $staticPage->slug : config("admin.constants.EmptyNotation") }}
                                        </td>

                                        <td>
                                            {{ !empty($staticPage->meta_title) ? $staticPage->meta_title : config("admin.constants.EmptyNotation") }}
                                        </td>

                                        <td style="width:30%" class="wordbreak">
                                             <span class=recommend-gte>
                                             
                                                {!! !empty($staticPage->content) ? \app\Helpers\CommonHelper::sortString(strip_tags($staticPage->content),$staticPage->id) : config("admin.constants.EmptyNotation") !!}                                           
                                            </span> 

                                            
                                        </td>

                                        <td>
                                            {{ !empty($staticPage->updated_at) ? $staticPage->updated_at : config("admin.constants.EmptyNotation") }}
                                        </td>
                                        <td class="action-btn">

                                        <span>
                                            {!! Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                            \Crypt::encryptString($staticPage->id)]]) !!}
                                            {!! Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left
                                            fa fa-edit', 'title' => 'Edit']) !!}
                                            {!! Form::close() !!}
                                        </span>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif

                    </div>
                    <!-- /.box-body -->
                    @if(count($staticPageList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $staticPageList])
                    @endif
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
<style>
#more {display: none;}
</style>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";


function readMoreLess(id) {   
  var dots = document.getElementById("dots"+id);
  var moreText = document.getElementById("more"+id);
  var btnText = document.getElementById("read-more-less"+id);
  

  if (dots.style.display === "none") {
    dots.style.display = "inline";
    btnText.innerHTML = "Read more"; 
    moreText.style.display = "none";
  } else {
    dots.style.display = "none";
    btnText.innerHTML = "Read less"; 
    moreText.style.display = "inline";
  }
}

</script>

@endsection
