@extends('layouts.Admin.adminForm')

@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="box">
            <div class="box-body">
                <div class="row">
                    {{ Form::model($staticPageDetail, array('route' => array('static-pages.update', \Crypt::encryptString($staticPageDetail->id)), 'method' => 'PUT','files' => true,'id'=>$formId)) }}

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="exampleInputName">Title</label>
                            {{ Form::text('title', null, array('class'=>'form-control required', 'id'=>'title','placeholder' => 'Name', 'disabled' => 'true')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputName">Content</label>
                            {{ Form::textarea('content', null, array('class'=>'form-control', 'id'=>'content','placeholder' => 'Content')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputName">Meta Title</label>
                            {{ Form::text('meta_title', null, array('class'=>'form-control', 'id'=>'meta_title','placeholder' => 'Meta Title')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputName">Meta Description</label>
                            {{ Form::text('meta_description', null, array('class'=>'form-control', 'id'=>'meta_description','placeholder' => 'Description')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Status</label>
                            {{Form::select('status',['1' => 'Active', '0' => 'Inactive'], (isset($staticPageDetail->status) && is_numeric($staticPageDetail->status) ? $staticPageDetail->status : ''), ['class'=>'form-control'])}}
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="col-md-6">
                                    {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                                </div>

                                <div class="col-md-6">
                                <a href="{{route('static-pages.index')}}">
                                        <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </section>
</div>
<!-- /.row -->
</section>
<!-- /.content -->
</div>
<script>
let baseURL = "{{\Config('admin.path.BASE_URL')}}";
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}/image-upload";
</script>
@endsection