@extends('layouts.Admin.adminForm')

@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-body">
                <!-- left column -->
                <div class="row">

                    {{ Form::model($smtpDetail, array('route' => array('smtp-settings.update', \Crypt::encryptString($smtpDetail->id)), 'method' => 'PUT','files' => false,'id'=>$formId)) }}

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Driver</label>
                            {{ Form::text('driver', null, array('class'=>'form-control required','maxlength'=>'50')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Host</label>
                            {{ Form::text('host', null, array('class'=>'form-control required','maxlength'=>'50')) }}
                        </div>

                        <div class="form-group">
                            <label for="username">Port</label>
                            {{ Form::text('port', null, array('class'=>'form-control required number','maxlength'=>'50')) }}
                        </div>

                        <div class="form-group">
                            <label for="password">User Name</label>
                            {{ Form::text('username', null, array('class'=>'form-control required','maxlength'=>'50')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Password</label>
                            {{ Form::text('password', null, array('class'=>'form-control required','maxlength'=>'100')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Encryption</label>
                            {{ Form::text('encryption', null, array('class'=>'form-control required','maxlength'=>'50')) }}
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="col-md-6">
                                {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                                </div>
                            </div>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
<script>
let baseURL = "{{\Config('admin.path.BASE_URL')}}";
</script>
@endsection