@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get','class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'Name', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-2">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{$url}}" class="btn btn-default">Reset</a>
                                </div>
                                <div class="col-sm-2">
                                    <a href="{{$url.'/create'}}" class="btn btn-primary pull-right addButton">+
                                        Create Role</a>
                                </div>
                                <div class="col-sm-2 ">
                                    @include('elements.Admin.export-file-link')
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($roleList) > 0)
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>@sortablelink('name', 'Name')</th>
                                        <th class="fourty">@sortablelink('description', 'Description')</th>
                                        <!--<th>Status</th>-->
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($roleList as $role)

                                        @php
                                        $viewUrl = url()->current().'/'.\Crypt::encryptString($role->id);
                                        $statusTitle = 'Inactive';
                                        $statusValue = 1;
                                        //$statusIconClass = 'fa fa-fw fa-check';
                                        $statusIconClass = 'glyphicon glyphicon-remove';
                                        if($role->status == 1){
                                        $statusTitle = 'Active';
                                        $statusValue = 0;
                                        //$statusIconClass = 'fa fa-fw fa-close';
                                        $statusIconClass = 'glyphicon glyphicon-ok';
                                        }
                                        @endphp

                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td>
                                            {{ !empty($role->name) ? $role->name : config("admin.constants.EmptyNotation") }}
                                        </td>

                                        <td style="width:30%" class="wordbreak">
                                            <span class="recommend-gte">
                                                {{ !empty($role->description) ? strip_tags($role->description) : config("admin.constants.EmptyNotation") }}
                                            </span>
                                        </td>

                                        <td class="action-btn-permission">
                                        @if(!$role->is_super_admin || $role->id !=
                                        Auth::guard('admin')->user()->role_id)
                                        <!-- change status of the resource -->
                                        <span style="float:left; margin:2px 10px;">
                                            <a href="javascript:void(0)" id="{{$role->id}}" data="{{\Crypt::encryptString($role->id)}}"
                                                baseUrl="{{$adminUrl.'/'.$controllerUri.'/'.\Crypt::encryptString($role->id).'/edit'}}"
                                                model="{{ \Crypt::encryptString('roles')}}" class="change-status-confirm"
                                                msg="{{__('admin/flash_msg.error.ConfirmChangeStatus')}}">
                                                <span style="cursor:pointer" class="glyphicon {{ ($role->status==1)?'glyphicon-ok':'glyphicon-remove' }}"
                                                    aria-hidden="true" title="{{($role->status==1)? 'Active' : 'Inactive'}}">
                                                </span>
                                            </a>
                                        </span>
                                        @else
                                        <span style="float:left; margin:2px 10px;">
                                                <span class="glyphicon glyphicon-ok" aria-hidden="true" title="Active">
                                                </span>
                                        </span>
                                        @endif

                                        <!-- edit resource -->
                                        <span>
                                            {!! Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                            \Crypt::encryptString($role->id)]]) !!}
                                            {!! Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left
                                            fa fa-edit', 'title' => 'Edit']) !!}
                                            {!! Form::close() !!}
                                        </span>

                                        @if(!$role->is_super_admin || $role->id !=
                                        Auth::guard('admin')->user()->role_id)
                                        <!-- delete resource -->
                                        <span>
                                            {!! Form::open(['method' => 'DELETE', 'route' => [$controllerUri.'.destroy',
                                            \Crypt::encryptString($role->id)]]) !!}
                                            {!! Form::button('', [
                                            'type' => 'submit',
                                            'class' => 'actions-btn delete-confirm pull-left fa fa-trash',
                                            'title' => 'Delete Title',
                                            'msg' => __('admin/flash_msg.error.ConfirmDelete')
                                            ]) !!}
                                            {!! Form::close() !!}
                                        </span>
                                        @endif

                                        @if(!$role->is_super_admin || $role->id !=
                                            Auth::guard('admin')->user()->role_id)
                                            <a href="{{$adminUrl.'/permissions?id='.\Crypt::encryptString($role->id)}}"
                                                title="Manage Permissions">
                                                <button class="btn btn-default fa fa-lock" type="button"></button>
                                            </a>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                    @if(count($roleList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $roleList])
                    @endif
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>

@endsection
