@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="box">
            <div class="box-body">
                <div class="row">
                    {!! Form::open(['route' => [$controllerUri.'.store'], 'method' => 'POST', 'id'=>
                    $formId, 'files' => true]) !!}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputName">Name</label>
                            {{ Form::text('name', '', ['class'=>'form-control required', 'id'=>'name','placeholder' => 'Name', 'onchange' => "return trim(this)"]) }}
                        </div>
                        <div class="form-group">
                            <label for="exampleInputName">Description</label>
                            {{ Form::textarea('description', '', ['class'=>'form-control required', 'id'=>'description','placeholder' => 'Role Description', 'onchange' => "return trim(this)"]) }}
                        </div>
                        <div class="form-group">
                            <label for="exampleInputEmail1">Status</label>
                            {{Form::select('status',['1' => 'Active', '0' => 'Inactive'], (!empty($roleDetail) && is_object($roleDetail) && !empty($roleDetail->status) ? $roleDetail->status : ''), ['class'=>'form-control'])}}
                        </div>
                        <div class="form-group" style="text-align: center">
                            <span>{{ Form::submit('Submit', ['class'=>'btn btn-success']) }}</span>
                            <span style="margin-left: 10px">
                                <a href="{{route('roles.index')}}">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </span>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </section>
</div>
@endsection