@extends('layouts.Admin.adminPopup')
@section('content')
<div class="content-wrapper" style="margin-left:0px !important;">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                        </div>
                    </div>

                    <div class="box-body">
                        <div class="new_product_form">
                            <div class="col-sm-6 owntable table-scrollable" style="width:100% !important;">


                                <table id="example1" class="table table-bordered table-striped">
                                   
                                   <tr>
                                        <th scope="row"><?=__('Name')?></th>
                                        <td>
                                            {{ !empty($restaurantData->name) ?$restaurantData->name : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Bio')?></th>
                                        <td>
                                            {{ !empty($restaurantData->bio) ? $restaurantData->bio : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?=__('Email Id')?></th>
                                        <td>
                                            {{ !empty($restaurantData->user->email) ? $restaurantData->user->email : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Phone Number')?></th>
                                        <td>
                                            {{ !empty($restaurantData->user->phone_number) ? $restaurantData->user->phone_number : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Profile Pic ')?>  </th>
                                        <td>

                                            @php
                                            $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id'=>$restaurantData->user->id])->latest()->first();
                                            @endphp
                                           @if(!empty($userAvatar->avatar))
                                           <div class="ImgPopup productimages" style="cursor: pointer"
                                                href="{{ $userAvatar->avatar }}">
                                                {{ Html::image($userAvatar->avatar, '', array('width' => 50,'height' => 50, 'title' => 'Restaurant Image')) }}
                                            </div>
                                            
                                            @else
                                            <div class="imgpreview" href="{{  $defaultRestaurantImage }}">
                                                {{ Html::image($defaultRestaurantImage, null, array('width' => 50, 'height' => 50)) }}
                                            </div>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?=__('Restaurant Type')?></th>
                                        <td>
                                            @if($restaurantData->resturent_type_local)
                                               Local,
                                            @endif

                                            @if($restaurantData->resturent_type_continental)
                                                Continental,
                                            @endif

                                            @if($restaurantData->resturent_type_groceries)
                                                Groceries
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Address1')?></th>
                                        <td>
                                            {{ !empty($restaurantData->address1) ? $restaurantData->address1 : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Address2')?></th>
                                        <td>
                                            {{ !empty($restaurantData->address2) ? $restaurantData->address2 : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('City')?></th>
                                        <td>
                                            {{ !empty($restaurantData->city) ? $restaurantData->city : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Region')?>  </th>
                                        <td>
                                            {{ !empty($restaurantData->region) ? $restaurantData->region : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Zip Code')?>  </th>
                                        <td>
                                            {{ !empty($restaurantData->zipcode) ? $restaurantData->zipcode : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>


                                    <tr>
                                        <th scope="row"><?=__('Delivery Time')?></th>
                                        <td>
                                            {{ !empty($restaurantData->delivery_time) ? $restaurantData->delivery_time.' min' : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>


                                    <tr>
                                        <th scope="row"><?=__('Created at')?></th>
                                        <td>
                                        {{ !empty($restaurantData->created_at) ? \Carbon\Carbon::parse($restaurantData->created_at)->format('d M, Y h:i a') : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Updated at')?></th>
                                        <td>
                                        {{ !empty($restaurantData->updated_at) ? \Carbon\Carbon::parse($restaurantData->updated_at)->format('d M, Y h:i a') : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
