@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                {{ Form::open(['method' => 'get', 'class' => 'form-horizontal']) }}
                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-2">
                                        {{ Form::text('search', app('request')->input('search'), ['placeholder' => 'Email or Name', 'class' => 'form-control']) }}
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            {{ Form::select('is_include_commission', [1 => 'Enable', 0 => 'Disable'], app('request')->input('is_include_commission'), ['class' => 'form-control', 'placeholder' => 'Commission']) }}
                                        </div>
                                    </div>


                                    <div class="col-md-2">
                                        {{ Form::select('resturent_type_local', [1 => 'Yes', 0 => 'No'], app('request')->input('resturent_type_local'), ['class' => 'form-control', 'placeholder' => 'Local']) }}
                                    </div>
                                    <div class="col-md-2">
                                        {{ Form::select('resturent_type_continental', [1 => 'Yes', 0 => 'No'], app('request')->input('resturent_type_continental'), ['class' => 'form-control', 'placeholder' => 'Continental']) }}
                                    </div>
                                    <div class="col-md-2">
                                        {{ Form::select('resturent_type_groceries', [1 => 'Yes', 0 => 'No'], app('request')->input('resturent_type_groceries'), ['class' => 'form-control', 'placeholder' => 'Grocery']) }}
                                    </div>

                                    <div class="col-md-2">
                                        {{ Form::select('status', [1 => 'Active', 0 => 'Inactive'], app('request')->input('status'), ['class' => 'form-control', 'placeholder' => 'Status']) }}
                                    </div>
                                    <div class="clearfix"></div>
                                    <div class="col-sm-2 pull-right">
                                        {{ Form::submit('Submit', ['class' => 'btn btn-success']) }}
                                        <a href="{{ $url }}" class="btn btn-default">Reset</a>
                                    </div>
                                </div>



                            </div>
                            {{ Form::close() }}
                        </div>
              

                    <div class="box-body">
                        <?php //echo "<pre>@@@"; print_r(count($restaurantList)); exit;
                        ?>
                        @if (count($restaurantList) > 0)
                            <div class="adminusers_table">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th width="4%">Sr.No.</th>
                                            <th width="10%">Name</th>
                                            <th width="18%">Bio</th>
                                            <th width="14%">Email</th>
                                            <th width="14%">Phone Number</th>
                                            <th width="10%">Profile Pic</th>
                                            <th width="10%">Approval Status</th>
                                            <th width="15%">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $srNo = $limit * ($page - 1) + 1;
                                        @endphp
                                        @foreach ($restaurantList as $restaurant)
                                            <tr>
                                                <td>{{ $srNo++ }}</td>
                                                <td>
                                                    <a href="{{ url($url . '/' . \Crypt::encryptString($restaurant->id)) }}"
                                                        class="various" data-fancybox-type="iframe"
                                                        title="View">{{ $restaurant->name }}</a>
                                                </td>
                                                <td>
                                                    {{ str_limit(strip_tags($restaurant->bio), 60) }}
                                                    @if (strlen(strip_tags($restaurant->bio)) > 50)
                                                        <a href="{{ url($url . '/' . \Crypt::encryptString($restaurant->id)) }}"
                                                            class="various" data-fancybox-type="iframe"
                                                            title="View">Read More</a>
                                                    @endif
                                                </td>
                                                <td>{{ !empty($restaurant->user->email) ? $restaurant->user->email : \config('admin.constants.EmptyNotation') }}
                                                </td>
                                                <td>{{ !empty($restaurant->user->phone_number) ? $restaurant->user->phone_number : \config('admin.constants.EmptyNotation') }}
                                                </td>

                                                <td>
                                                    @php
                                                   if(isset($restaurant->user) && $restaurant->user->id!=''){
                                                    $resUser = $restaurant->user->id;
                                                   }else{
                                                    $resUser =1; 
                                                   }
                                                    
                                                    

                                                        $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id' => $resUser])
                                                            ->latest()
                                                            ->first();
                                                    @endphp
                                                    @if (!empty($userAvatar->avatar))
                                                        <div class="ImgPopup productimages" style="cursor: pointer"
                                                            href="{{ $userAvatar->avatar }}">
                                                            {{ Html::image($userAvatar->avatar, '', ['width' => 50, 'height' => 50, 'title' => 'Restaurant Image']) }}
                                                        </div>
                                                    @else
                                                        <div class="ImgPopup productimages"
                                                            href="{{ $defaultRestaurantImage }}">
                                                            {{ Html::image($defaultRestaurantImage, null, ['width' => 50, 'height' => 50]) }}
                                                        </div>
                                                    @endif
                                                </td>



                                                <td>
                                                    @if ($restaurant->status == 1)
                                                        <button type="button" class="btn btn-success btn-sm"
                                                            title="Approved" disabled="disabled"
                                                            class="change-status-confirm"
                                                            style="padding: 2px 20px; margin-bottom: 10px; font-size: 14px;">Approved
                                                        </button>
                                                        <button type="button" class="btn btn-primary btn-sm buttonload"
                                                            id="Disapprove{{ $restaurant->id }}" title="Disapprove"
                                                            style="padding: 2px 10px;"
                                                            onclick="rst_action('Disapprove', <?php echo $restaurant->id; ?>);">Disapprove</button>
                                                    @elseif($restaurant->status == 2)
                                                        <button type="button" class="btn btn-primary btn-sm"
                                                            title="Disapproved" disabled="disabled"
                                                            style="padding: 2px 9px; font-size: 14px; margin-bottom: 10px;">Disapproved</button>
                                                        <button type="button" class="btn btn-success btn-sm buttonload"
                                                            id="Approve{{ $restaurant->id }}" title="Approve"
                                                            style="padding: 2px 16px;"
                                                            onclick="rst_action('Approve', <?php echo $restaurant->id; ?>);">Approve
                                                            &nbsp;&nbsp;</button>
                                                    @else
                                                        <button type="button" class="btn btn-success btn-sm buttonload"
                                                            id="Approve{{ $restaurant->id }}" title="Approve"
                                                            style="padding: 2px 13px; margin-bottom: 10px;"
                                                            onclick="rst_action('Approve', <?php echo $restaurant->id; ?>);">Approve
                                                            &nbsp;&nbsp;</button>
                                                        <button type="button" class="btn btn-primary btn-sm buttonload"
                                                            id="Disapprove{{ $restaurant->id }}" title="Disapprove"
                                                            style="padding: 2px 9px;"
                                                            onclick="rst_action('Disapprove', <?php echo $restaurant->id; ?>);">Disapprove</button>
                                                    @endif
                                                </td>
                                                <td class="action-btn-permission">
                                                    @include(
                                                        'elements.Admin.restaurant-actions-link',
                                                        ['row' => $restaurant]
                                                    )
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <table class="table">
                                <tr>
                                    <td colspan="10" class="text-danger text-center error-msg">
                                        {{ config('flash_msg.NoRecordFound') }}</td>
                                </tr>
                            </table>
                        @endif
                    </div>
                    @if (count($restaurantList) > 0)
                        @include('elements.Admin.pagination-link', [
                            'dataList' => $restaurantList,
                        ])
                    @endif
                </div>
            </div>
    </div>
    </section>
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";


        // * Author: Bibhash kumar
        // * Email: bibhash.shisodiya@nmgtechnologies.com
        // * @Description: To Approve from admin for restaurant record.
        // * @Created 24/June/2021
        // * @Updated 24/June/2021

        function rst_action(approvalStatus, id) {
            $("#" + approvalStatus + id).html('<i class="fa fa-refresh fa-spin faicon"></i>' + approvalStatus);
            $.ajax({
                url: adminURL + "/restaurant-approval",
                type: "get",
                data: {
                    status: approvalStatus,
                    id: id
                },
                success: function(data) {
                    //alert(data);
                    location.reload();
                }
            });
        }
    </script>
@endsection
