@extends('layouts.Admin.adminForm')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>{{ $title }} : {{ $subTitle }}</h1>
            @include('elements.Admin.breadcrumb')
        </section>

        <!-- Main content -->
        <section class="content main_box">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                    <!-- general form elements -->
                    <div class="box box-primary">
                        {{ Form::model($userDetail, ['route' => [$controllerUri . '.update', \Crypt::encryptString($userDetail->id)],'method' => 'PUT','novalidate' => 'false','files' => true,'id' => $formId]) }}

                        <div class="box-body form_box">
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Name</label>
                                        {{ Form::text('restaurant_name', $userDetail->name, ['class' => 'form-control required','id' => 'restaurant_name','placeholder' => 'Restaurant Name','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Email</label>
                                        {{ Form::email('email', $userDetail->user->email, ['class' => 'form-control required ','id' => 'restaurant_email_id','disabled' => 'disabled','placeholder' => 'Email Id','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>
                            </div>

                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="col-md-12">Phone Number</label>

                                        <div class="col-md-3">
                                            <input value="+233" class="form-control" type="text" disabled>
                                        </div>
                                        <div class="col-md-9">
                                            {{ Form::number('restaurant_phone_number', $userDetail->user->phone_number, ['class' => 'form-control required','id' => 'restaurant_phone_number','placeholder' => 'Phone number: eg; 8888888888','onchange' => 'return trim(this)']) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="address">Address1</label>
                                        {{ Form::text('address1', $userDetail->address1, ['class' => 'form-control required','autocomplete' => 'off','id' => 'address1','onFocus' => 'initializeAutocomplete()','placeholder' => 'Address1','onchange' => 'return trim(this)']) }}
                                        <span id="addressAdmin-error" class="help-block" style="color:red;"></span>

                                    </div>
                                </div>
                            </div>
                            <div class="row input_row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Bio</label>

                                        {{ Form::textarea('restaurant_bio', $userDetail->bio, ['class' => 'form-control required','id' => 'restaurant_bio','rows' => 5,'placeholder' => 'Restaurant Bio','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Address2</label>
                                        {{ Form::text('address2', !empty($userDetail->address2) ? $userDetail->address2 : '', ['class' => 'form-control required','id' => 'address2','placeholder' => 'Address2','onchange' => 'return trim(this)']) }}
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Region</label>
                                        {{ Form::text('country', $userDetail->region, [
                                            'class' => 'form-control required',
                                            'id' => 'country',
                                            'placeholder' => 'Region',
                                            'onchange' => 'return trim(this)',
                                        ]) }}
                                    </div>
                                </div>

                            </div>
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="restaurant_lat">City</label>
                                        {{ Form::text('locality', $userDetail->city, ['class' => 'form-control required','id' => 'locality','placeholder' => 'City','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="postal_code">Zip Code </label>
                                    {{ Form::text('postcode', $userDetail->zipcode, [
                                        'class' => 'form-control',
                                        'id' => 'postcode',
                                        'placeholder' => 'Zip Code',
                                    ]) }}

                                    {{ Form::hidden('latitude', $userDetail->latitude, ['id' => 'latitude']) }}
                                    {{ Form::hidden('longitude', $userDetail->longitude, ['id' => 'longitude']) }}
                                </div>
                            </div>

                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="image-upload">
                                                <div class="file-label" style="text-align: left">Upload Image</div>
                                                {{ Form::file('avatar', ['id' => 'avatar']) }}
                                            </div>
                                        </div>
                                        @php
                                            $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id' => $userDetail->user->id])
                                                ->latest()
                                                ->first();
                                        @endphp
                                        @if (!empty($userAvatar->avatar))
                                            <div class="ImgPopup productimages" style="cursor: pointer"
                                                href="{{ $userAvatar->avatar }}">
                                                {{ Html::image($userAvatar->avatar, '', ['width' => 50, 'height' => 50, 'title' => 'Restaurant Image']) }}
                                            </div>
                                        @else
                                            <div class="ImgPopup productimages" href="{{ $defaultRestaurantImage }}">
                                                {{ Html::image($defaultRestaurantImage, null, ['width' => 50, 'height' => 50]) }}
                                            </div>
                                        @endif

                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label for="restaurant_lat">Delivery Time</label>
                                    {{ Form::text('deliverytime', $userDetail->delivery_time, ['class' => 'form-control required','id' => 'deliverytime','placeholder' => 'Delivery Time','onchange' => 'return trim(this)']) }}
                                </div>

                            </div>
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <!-- <div class="form-group"> -->
                                    <label for="exampleInputEmail1">Restaurant Type</label>
                                    <div class="form-group">
                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="resturent_type_local"
                                                value="{{ $userDetail->resturent_type_local ? 1 : 0 }}"
                                                class="restaurantType"
                                                {{ $userDetail->resturent_type_local ? 'checked' : '' }}>Local
                                        </label>

                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="resturent_type_continental"
                                                value="{{ $userDetail->resturent_type_continental ? 1 : 0 }}"
                                                class="restaurantType"
                                                {{ $userDetail->resturent_type_continental ? 'checked' : '' }}>Continental
                                        </label>
                                        <label class="checkbox-inline">
                                            <input type="checkbox" name="resturent_type_groceries"
                                                value="{{ $userDetail->resturent_type_groceries ? 1 : 0 }}"
                                                class="restaurantType"
                                                {{ $userDetail->resturent_type_groceries ? 'checked' : '' }}>Groceries
                                        </label>
                                        <span id="restaurant_type-error" class="help-block" style="color:red;"></span>
                                    </div>
                                    <!--  </div> -->
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Commission</label>
                                        {{ Form::select('is_include_commission',[1 => 'Enable', 0 => 'Disable'],isset($userDetail->is_include_commission) && is_numeric($userDetail->is_include_commission)? $userDetail->is_include_commission: 0,['class' => 'form-control']) }}
                                    </div>
                                </div>


                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Status</label>
                                        {{ Form::select('status',[1 => 'Active', 0 => 'Inactive'],isset($userDetail->user->status) && is_numeric($userDetail->user->status) ? $userDetail->user->status : 0,['class' => 'form-control']) }}
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="box-footer row">
                            <div class="col-md-6">
                                {{ Form::submit('Submit', ['class' => 'btn btn-success pull-right', 'id' => 'restaurantUpd']) }}
                            </div>
                            <div class="col-md-6">
                                <a href="{{ route('restaurant.index') }}">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
    <script defer src="{{ asset('resources/assets/js/address.js') }}"></script>
    <script src="//maps.googleapis.com/maps/api/js?libraries=places&key={{ env('ADDRESS_API_KEY') }}"></script>
@endsection
