@extends('layouts.Admin.adminPopup')
@section('content')
<div class="content-wrapper" style="margin-left:0px !important;">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                        </div>
                    </div>

                    <div class="box-body">
                        <div class="new_product_form">
                            <div class="col-sm-6 owntable table-scrollable" style="width:100% !important;">
                                <table id="example1" class="table table-bordered table-striped">
                                    
                                    <tr>
                                        <th scope="row"><?=__('User Name')?></th>
                                        <td>
                                            {{ !empty($userDetail->user_name) ? $userDetail->user_name : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('First Name')?></th>
                                        <td>
                                            {{ !empty($userDetail->first_name) ? $userDetail->first_name : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Last Name')?></th>
                                        <td>
                                            {{ !empty($userDetail->last_name) ? $userDetail->last_name : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Email Id')?></th>
                                        <td>
                                            {{ !empty($userDetail->email) ? $userDetail->email : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Phone Number')?></th>
                                        <td>
                                            {{ !empty($userDetail->mobile_no) ? $userDetail->mobile_no : \config('admin.constants.EmptyNotation') }}
                                        </td>
                                    </tr>
                                    
                                    
                                    <tr>
                                        <th scope="row"><?=__('Status')?></th>
                                        <td>
                                            {{ \config('admin.constants.STATUS')[$userDetail->status] }}
                                        </td>
                                    </tr>

                                    <tr>
                                        <th scope="row"><?=__('Image')?></th>
                                        <td>
                                        @php 
                                    $medicalImage = \app\Helpers\CommonHelper::getuserAvatarUri($userDetail->id);
                                @endphp
                                @if(!empty($medicalImage))
                                
                                    {{ Html::image($medicalImage['origional'], null, ['width' => 50,'height' => 50]) }}
                                
                                @else
                                <div class="imgpreview" href="{{  $defaultAvatarUrl }}">
                                    {{ Html::image($defaultAvatarUrl, null, ['width' => 50,'height' => 50]) }}
                                </div>
                                @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection