@extends('layouts.Admin.adminPdf')
@section('content')
<div class="content-wrapper" style="margin-left:0px !important;">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">
                        @if(count($medicalWorkerList) > 0)
                        <div class="roles_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>User Name</th>
                                        <th>Email</th>
                                        <th>Mobile Number</th>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($medicalWorkerList as $row)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td>
                                            {{ !empty($row->user_name) ? $row->user_name : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <td>
                                            {{ !empty($row->email) ? $row->email : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <td>
                                            {{ !empty($row->mobile_no) ? $row->mobile_no : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <td>
                                            {{ !empty($row->first_name) ? $row->first_name : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        <td>
                                            {{ !empty($row->last_name) ? $row->last_name : \config('admin.constants.EmptyNotation') }}
                                        </td>

                                        @if(!$row->is_super_admin)
                                        <td id="{{$row->id}}" data="{{\Crypt::encryptString($row->id)}}"
                                            model="{{ \Crypt::encryptString('roles')}}"
                                            class="change-status-confirm {{$row->status }}"
                                            msg="{{__('admin/flash_msg.error.ConfirmChangeStatus')}}">
                                            <span style=" cursor:pointer"
                                                class="glyphicon {{ ($row->status==1)?'glyphicon-ok':'glyphicon-remove' }}"
                                                aria-hidden="true" title="{{($row->status==1)? 'Active' : 'Inactive'}}">
                                            </span>
                                        </td>
                                        @else
                                        <td id="{{$row->id}}" msg="Status can not be changed for this title.."
                                            class="change-status-alert">
                                            <span class="glyphicon glyphicon-ok" aria-hidden="true" title="Active">
                                            </span>
                                        </td>
                                        @endif
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
@endsection
