@extends('layouts.Admin.adminForm')
@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content permissions">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">
                        @if(count($rolesList) && !empty($rolesList))
                        @foreach($rolesList as $role)
                        <h4>{{$roleName}} : Permissions</h4>
                        @endforeach
                        @endif
                        @if(count($modulesList) && !empty($modulesList))

                        <div id="tree-view" class="checktree" data-roleid="{{\Crypt::encryptString($roleId)}}">

                        </div>
                        <div class="col-xs-6">
                            <button id="save-permissions" class="btn btn-success btn-sm" type="button">Update
                                Permissions</button>
                        </div>
                        <div class="col-xs-6">
                            <a href="{{route('roles.index')}}"><button class="btn btn-default pull-right"
                                    type="button">Back</button></a>
                        </div>
                        @else
                        <h6 class="error-msg">{{config('flash_msg.NoRecordFound')}}</h6>
                        <div class="col-xs-6">
                            <a href="{{route('roles.index')}}"><button class="btn btn-default pull-right"
                                    type="button">Back</button></a>
                        </div>
                        @endif
                    </div>


                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
        <!-- /.col -->
    </section>
</div>
{!! Html::script('/resources/assets/plugins/treeview/js/jquery.treeview.updated.js'); !!}
<script>
var adminUrl = "{{$adminUrl}}";
var jsonObj = JSON.parse('<?php echo json_encode($modulesList); ?>');
</script>
<link href="<?=url('/')?>/resources/assets/plugins/treeview/css/jquery.treeview.css" rel="stylesheet">
@endsection
