@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            </div>
                        </div>

                        <div class="box-body">
                            <div class="new_product_form">
                                <div class="col-sm-6 owntable table-scrollable" style="width:100% !important;">
                                    <table id="example1" class="table table-bordered table-striped">

                                        <tr>
                                            <th scope="row"><?= __('Order ID') ?></th>
                                            <td>
                                                {{ $orderData->id }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Order Status') ?></th>
                                            <td>
                                                {{ $orderData->orderStatus->name }}

                                                @php echo \app\Traits\OrderStatusTrait::orderStatusOptionHandler($orderData->order_status_id, $orderData->id) @endphp
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Txn no') ?></th>
                                            <td>
                                                {{ $orderData->transaction->txn_no }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Txn Mode') ?></th>
                                            <td>
                                                {{ \app\Helpers\CommonHelper::getTransactionMode($orderData->transaction->mode) }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Customer Name') ?></th>
                                            <td>

                                                {{ $orderData->firstname . ' ' . $orderData->lastname }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Phone Number') ?></th>
                                            <td>
                                                {{ $orderData->phone_number }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Email') ?></th>
                                            <td>
                                                {{ $orderData->email }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Delivery Address1') ?></th>
                                            <td>
                                                {{ $orderData->address1 }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Delivery Address2') ?></th>
                                            <td>
                                                {{ $orderData->address2 }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('City') ?></th>
                                            <td>
                                                {{ $orderData->city }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('State') ?></th>
                                            <td>
                                                {{ $orderData->state }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Zipcode') ?></th>
                                            <td>
                                                {{ $orderData->zipcode }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Address Type') ?></th>
                                            <td>
                                                {{ \app\Helpers\CommonHelper::getAddressType($orderData->address_type) }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Delivery Note') ?></th>
                                            <td>
                                                {{ $orderData->delivery_note }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Order Location') ?></th>
                                            <td>
                                                <div id="map" style="width:400px;height:300px;"></div>
                                            </td>
                                        </tr>


                                        <tr>
                                            <th scope="row"><?= __('Distance') ?></th>
                                            <td>
                                                {{ $orderData->distance . ' Miles' }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Created at') ?></th>
                                            <td>
                                                {{ !empty($orderData->created_at) ? \Carbon\Carbon::parse($orderData->created_at)->format('d-M-Y H:i:s a') : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="text-center" colspan="2">Restaurant details</th>
                                        </tr>
                                        <tr>

                                        </tr>


                                        <tr>
                                            <th scope="row"><?= __('Restaurant Name') ?></th>
                                            <td>
                                                {{ $orderData->restaurant->name }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant address') ?></th>
                                            <td>
                                                {{ $orderData->restaurant->address1 }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant phone no') ?></th>
                                            <td>
                                                {{ $orderData->restaurant->user->phone_number }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant email') ?></th>
                                            <td>
                                                {{ $orderData->restaurant->user->email }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Restaurant status') ?></th>
                                            <td>
                                                {{ $orderData->restaurant->user->is_active == 1 ? 'Online' : 'Offline' }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th class="text-center" colspan="2">Delivery person details</th>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Name') ?></th>
                                            <td>
                                                {{ !empty($orderData->deliveryPerson->user->first_name) ? $orderData->deliveryPerson->user->first_name : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Phone number') ?></th>
                                            <td>
                                                {{ !empty($orderData->deliveryPerson->user->phone_number) ? $orderData->deliveryPerson->user->phone_number : \config('admin.constants.EmptyNotation') }}


                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Age') ?></th>
                                            <td>
                                                {{ !empty($orderData->deliveryPerson->age) ? $orderData->deliveryPerson->age : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Image') ?></th>
                                            <td>

                                                @if (!empty($orderData->deliveryPerson->user->profile_image))
                                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                                        href="{{ $orderData->deliveryPerson->user->profile_image }}">
                                                        {{ Html::image($orderData->deliveryPerson->user->profile_image, '', ['width' => 50, 'height' => 50, 'title' => 'Restaurant Image']) }}
                                                    </div>
                                                @else
                                                    <div class="ImgPopup productimages" style="cursor: pointer"
                                                        href="{{ $defaultAvatarUrl }}">
                                                        {{ Html::image($defaultAvatarUrl, null, ['width' => 50, 'height' => 50]) }}
                                                    </div>
                                                @endif
                                            </td>
                                        </tr>

                                        <tr>
                                            <th class="text-center" colspan="2">Order items</th>
                                        </tr>


                                        <tr>
                                            <td colspan="2">
                                                <table class="table table-bordered table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>Item</th>
                                                            <th>Image</th>
                                                            <th>Price</th>
                                                            <th>Qty</th>
                                                            <th>Total</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($orderData->orderItem as $item)
                                                            <tr>
                                                                <td>{{ $item->itemDetail->name }}</td>
                                                                <td>

                                                                    @if (!empty($item->itemDetail->image))
                                                                        <div class="ImgPopup productimages"
                                                                            style="cursor: pointer"
                                                                            href="{{ $item->itemDetail->image }}">
                                                                            {{ Html::image($item->itemDetail->image, '', ['width' => 50, 'height' => 50, 'title' => 'Profile Image']) }}
                                                                        </div>
                                                                    @else
                                                                        <div class="imgpreview"
                                                                            href="{{ $defaultAvatarUrl }}">
                                                                            {{ Html::image($defaultAvatarUrl, null, ['width' => 50, 'height' => 50]) }}
                                                                        </div>
                                                                    @endif
                                                                </td>
                                                                <td>({{ config('admin.constants.CURRENCY') }})
                                                                    {{ $item->item_price }}</td>
                                                                <td>{{ $item->item_qty }}</td>
                                                                <td>({{ config('admin.constants.CURRENCY') }})
                                                                    {{ $item->item_price * $item->item_qty }}</td>
                                                            </tr>
                                                        @endforeach

                                                        <tr>
                                                            <td colspan="4">Sub total</td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->sub_total }}</td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Service Fee (

                                                                {{ $orderData->tax_value }}
                                                                {{ $orderData->tax_type == 'percentage' ? '%' : 'Fixed Amount ' }})
                                                            </td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->tax }}</td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Commission
                                                                ({{ $orderData->commission_percentage }}%)</td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->commission }}</td>
                                                        </tr>


                                                        <tr>
                                                            <td colspan="4">Delivery charges</td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->delivery_charge }}</td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Rider Revenue</td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->delivery_person_revenue }}</td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Revenue on Delivery Charges</td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->revenue_on_delivery_charge }}</td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="4">Grand total</td>
                                                            <td>({{ config('admin.constants.CURRENCY') }})
                                                                {{ $orderData->total_amount }}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>



                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
    </script>


    <script>
        // Initialize and add the map
        function initMap() {
            // The order location
            const orderLocation = {
                lat: {{ $orderData->latitude }},
                lng: {{ $orderData->longitude }}
            };

            const restaurantLocation = {
                lat: {{ $orderData->restaurant->latitude }},
                lng: {{ $orderData->restaurant->longitude }}
            };

            // The map, centered at orderLocation
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 8,
                center: orderLocation,
            });
            // The marker, positioned at orderLocation
            var marker = new google.maps.Marker({
                position: orderLocation,
                map: map,
                label: 'Customer'
            });

            var marker = new google.maps.Marker({
                position: restaurantLocation,
                map: map,
                label: 'Restaurant'
            });
        }
    </script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key={{ env('ADDRESS_API_KEY') }}&callback=initMap&libraries=&v=weekly">
    </script>
@endsection
