@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                {{ Form::open(['method' => 'get', 'class' => 'form-horizontal']) }}
                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-2">
                                        {{ Form::text('search', app('request')->input('search'), ['placeholder' => 'Order ID', 'class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::select('restaurant', $restaurantList, app('request')->input('restaurant'), ['placeholder' => 'Select Restaurant', 'class' => 'form-control select2']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::select('status', $orderStatusList, app('request')->input('status'), ['placeholder' => 'Select Status', 'class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::date('start_date', app('request')->input('start_date'), ['placeholder' => 'End Date', 'class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::date('end_date', app('request')->input('end_date'), ['placeholder' => 'End Date', 'class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::submit('Search', ['class' => 'btn btn-success']) }}
                                        <a href="{{ $url }}" class="btn btn-default">Reset</a>
                                    </div>


                                </div>
                                {{ Form::close() }}
                            </div>
                        </div>
                        <div class="box-body">
                            @if (count($orderList) > 0)
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th width="15%">Order ID</th>
                                                <th>Customer Name</th>
                                                <th>Delivery Person Name</th>
                                                <th>Restaurant Name</th>
                                                <th>Order Date</th>
                                                <th>Order Status</th>
                                                <th width="15%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($orderList as $order)
                                                <tr>
                                                    <td>{{ $order->id }}</td>
                                                    <td>
                                                        <a href="{{ url($customerUrl . '/' . \Crypt::encryptString($order->user_id)) }}"
                                                            class="various" data-fancybox-type="iframe" title="View">
                                                            {{ $order->firstname . ' ' . $order->lastname }}
                                                        </a>
                                                    </td>

                                                    <td>
                                                        @if (!empty($order->deliveryPerson))
                                                            <a href="{{ url($deliveryPersonUrl . '/' . \Crypt::encryptString($order->deliveryPerson->id)) }}"
                                                                class="various" data-fancybox-type="iframe"
                                                                title="View">
                                                                {{ $order->deliveryPerson->user->first_name . ' ' . $order->deliveryPerson->user->last_name }}
                                                            </a>
                                                        @else
                                                            {{ 'N/A' }}
                                                        @endif
                                                    </td>


                                                    <td>
                                                        <a href="{{ url($restaurantUrl . '/' . \Crypt::encryptString($order->restaurant_id)) }}"
                                                            class="various" data-fancybox-type="iframe" title="View">
                                                            {{ $order->restaurant->name }}
                                                        </a>
                                                    </td>
                                                    <td>{{ \Carbon\Carbon::parse($order->created_at)->format('d-M-Y') }}
                                                    </td>
                                                    <td>{{ $order->orderStatus->name }}</td>


                                                    <td class="action-btn-permission">

                                                        @include('elements.Admin.order-action-link', [
                                                            'row' => $order,
                                                        ])
                                                    </td>


                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            {{ config('flash_msg.NoRecordFound') }}</td>
                                    </tr>
                                </table>
                            @endif
                        </div>
                        @if (count($orderList) > 0)
                            @include('elements.Admin.pagination-link', [
                                'dataList' => $orderList,
                            ])
                        @endif
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
    </script>

@endsection
