@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                {{ Form::open(['method' => 'get', 'class' => 'form-horizontal']) }}
                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-4">
                                        {{ Form::text('search', app('request')->input('search'), ['placeholder' => 'Order ID / Username','class' => 'form-control']) }}
                                    </div>
                                    <div class="col-sm-2">
                                        {{ Form::date('start_date', app('request')->input('start_date'), ['placeholder' => 'End Date','class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::date('end_date', app('request')->input('end_date'), ['placeholder' => 'End Date','class' => 'form-control']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::submit('Search', ['class' => 'btn btn-success']) }}
                                        <a href="{{ $url }}" class="btn btn-default">Reset</a>
                                    </div>


                                </div>
                                {{ Form::close() }}
                            </div>
                        </div>

                        <div class="box-body">
                            @if (count($notificationList) > 0)
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th width="5%">Date</th>
                                                <th width="5%">Order ID</th>
                                                <th width="15%">User</th>
                                                <th width="15%">User Type</th>
                                                <th width="15%">Phone Number</th>
                                                <th width="15%">Email</th>
                                                <th width="15%">Title</th>
                                                <th width="15%">Description</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $srNo = $limit * ($page - 1) + 1;
                                            @endphp
                                            @foreach ($notificationList as $notification)
                                                <tr
                                                    class="{{ $notification->is_read == 1 ? 'read-notification-tr' : 'unread-notification-tr' }}">
                                                    <td>{{ \Carbon\Carbon::parse($notification->created_at)->format('M d,Y h:i a') }}
                                                    </td>
                                                    <td> {{ $notification->order_id }} </td>

                                                    <td>
                                                        @if ($notification->user->role_id == config('admin.constants.RESTAURANT_OWNER_ROLE'))
                                                            {{ $notification->restaurant->name }}
                                                        @else
                                                            @if ($notification->user->is_delivery_person == 1)
                                                                {{ $notification->user->first_name . ' ' . $notification->user->last_name }}
                                                            @else
                                                                {{ $notification->user->first_name . ' ' . $notification->user->last_name }}
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>{{ \app\Helpers\CommonHelper::getRoleForNotification($notification->user->role_id, $notification->action_id) }}
                                                    </td>
                                                    <td>{{ $notification->user->phone_number }} </td>
                                                    <td>{{ $notification->user->email }} </td>

                                                    <td>
                                                        @if (!empty($notification->order_id))
                                                            <a target="_blank"
                                                                href="{{ url(config('admin.constants.ADMIN_ROUTE_NAME') . '/order/' . \Crypt::encryptString($notification->order_id)) }}">
                                                                {{ $notification->title }}
                                                            </a>
                                                        @else
                                                            {{ $notification->title }}
                                                        @endif
                                                    </td>
                                                    <td>{{ $notification->description }} </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            {{ config('flash_msg.NoRecordFound') }}</td>
                                    </tr>
                                </table>
                            @endif
                        </div>
                        @if (count($notificationList) > 0)
                            @include('elements.Admin.pagination-link', [
                                'dataList' => $notificationList,
                            ])
                        @endif
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
    </script>
@endsection
