@extends('layouts.Admin.mailboxForm')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="box">
            <div class="box-body">
                <div class="row" id="results">
                    {!! Form::open(['route' => [$controllerUri.'.store'], 'method' => 'POST', 'id'=>
                    $formId, 'files' => true]) !!}
                    <!-- /.col -->
                    <div class="col-md-9">
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title">{{$subTitle}}</h3>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <!-- radio -->
                                <div class="form-group" id="inline_content">
                                    <label style="margin:10px;">
                                        <input type="radio" name="type" value="single" id="single" class="flat-red"
                                            checked="checked">
                                        Single
                                    </label>
                                    <!-- <label style="margin:10px;">
                                        <input type="radio" name="type" value="bulk" id="bulk" class="flat-red">
                                        Bulk
                                    </label> -->
                                </div>
                                <!-- <div class="form-group volatile bulk" style="display:none">
                                    <label for="exampleInputEmail1">Roles:</label>
                                    {{ Form::select('role_id', [0 => '-- All --']+@$roles, null, ['id' => 'role_id', 'name' => 'role_id[]', 'class' => 'form-control select2', 'multiple'=>'multiple', 'data-placeholder'=>'Select a Role', 'style'=>'width: 100%;']) }}
                                </div> -->

                                <div class="form-group volatile single">
                                    <label for="exampleInputName">To:</label>
                                    {{ Form::text('email', null, ['class'=>'form-control', 'id'=>'email','placeholder' => 'To:', 'onchange' => "return trim(this)"]) }}
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputName">Subject</label>
                                    {{ Form::text('subject', null, ['class'=>'form-control required', 'id'=>'subject','placeholder' => 'Subject:', 'onchange' => "return trim(this)"]) }}
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputName">Content</label>
                                    {{ Form::textarea('content', null, array('class'=>'form-control', 'id'=>'content','placeholder' => 'Content')) }}
                                </div>
                                <div class="form-group">
                                    <div class="btn btn-default btn-file">
                                        <i class="fa fa-paperclip"></i> Attachment
                                        {{ Form::file('attachment', ['id' => 'attachment']) }}
                                        <label class="custom-file-label" for="inputGroupFile02">&nbsp;</label>
                                    </div>
                                    <p class="help-block">Max. 32MB</p>
                                </div>
                                <!-- <div class="panel box box-success">
                                    <div class="box-header with-border">
                                        <h4 class="box-title">
                                            <a data-toggle="collapse" data-parent="#accordion" href="#collapseThree">
                                                Push Notification Filelds
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="collapseThree" class="panel-collapse collapse">
                                        <div class="box-body">
                                            App Users (Medical Workers) will receive push notifications, if below two
                                            fields are filled-
                                            <ul>
                                                <li>Push Title : Maximum length of 40 charecters.</li>
                                                <li>Push Content : Maximum length of 100 charecters.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputName">Push Title</label>
                                    {{ Form::text('push_title', null, ['class'=>'form-control required', 'id'=>'push_title','placeholder' => 'Push Title: Only 40 charectrers allowed', 'maxlength' => 40, 'onchange' => "return trim(this)"]) }}
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputName">Push Content</label>
                                    {{ Form::textarea('push_content', null, ['class'=>'form-control', 'id'=>'push_content','placeholder' => 'Push Content: Only 100 charectrers allowed', 'rows' => 3, 'maxlength' => 100]) }}
                                </div>                                
                            </div> -->
                            <!-- /.box-body -->
                            <div class="box-footer">
                                <div class="pull-right">
                                    <input type="hidden" id="confirmMsg"
                                        value="{{__('admin/validation/mailbox.success.sendEmail')}}" />
                                    <input type="hidden" id="postUrl" value="{{$adminUrl}}/mailboxsend" />
                                    <button type="submit" class="btn btn-primary broadcast-email" id="btnGet">
                                        Send <i class="fa fa-fw fa-arrow-circle-o-right"></i></button>
                                </div>
                                <button type="reset" class="btn btn-default"><i class="fa fa-times"></i>
                                    Discard</button>
                            </div>
                            <!-- /.box-footer -->
                        </div>
                        <!-- /. box -->
                    </div>
                    <!-- /.col -->
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </section>
</div>

<div id="fade"></div>
<div id="modal" class="center">
    <img src="{{URL::asset('/public/images/admin/loading.gif')}}" alt="Processing" id="loader">
</div>
<script>
let baseURL = "{{\Config('admin.path.BASE_URL')}}";
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}/mailbox-image-upload";
</script>
@endsection