@extends('layouts.Admin.adminDatagrid')

@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
</section>
<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box">
                <div class="box-body">
                    <div class="globalsettings_table">
                        <table class="table">
                            @if(count($globalsettings) && !empty($globalsettings))
                            <thead>
                                <tr>
                                    <th>Sr.No.</th>
                                    <th>Slug</th>
                                    <th>Value</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                $page = empty(request()->get('page'))?1:request()->get('page');
                                $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                @endphp
                                @foreach($globalsettings as $setting)
                                <tr>
                                    <td>{{ $srNo++ }}</td>
                                    <td><span class="recommend-gte">{{ $setting->slug }}</span>
                                    </td>

                                    <td>
                                        {{ !empty($setting->value) ? strip_tags(substr($setting->value,0,30)):"" }}


                                        {{ (strlen($setting->value) > 30)?' ..':'' }}
                                    </td>
                                    <td class="action-btn">
                                    <span style="float:left; margin:2px 10px;">
                                            <a href="javascript:void(0)" id="{{$setting->id}}" data="{{\Crypt::encryptString($setting->id)}}"
                                                baseUrl="{{$adminUrl.'/'.$controllerUri.'/'.\Crypt::encryptString($setting->id).'/edit'}}"
                                                model="{{ \Crypt::encryptString('global_settings')}}" class="change-status-confirm"
                                                msg="{{__('admin/flash_msg.error.ConfirmChangeStatus')}}">
                                                <span style="cursor:pointer" class="glyphicon {{ ($setting->status==1)?'glyphicon-ok':'glyphicon-remove' }}"
                                                    aria-hidden="true" title="{{($setting->status==1)? 'Active' : 'Inactive'}}">
                                                </span>
                                            </a>
                                        </span>

                                        <!-- edit resource -->
                                        <span>
                                        {!! Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                        \Crypt::encryptString($setting->id)]]) !!}
                                        {!! Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left
                                        fa fa-edit', 'title' => 'Edit']) !!}
                                        {!! Form::close() !!}
                                        </span>
                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                            @else
                            <td colspan="5" class="text-danger text-center error-msg">
                                {{config('flash_msg.NoRecordFound')}}</td>
                            @endif
                        </table>
                    </div>
                </div>
                <!-- /.box-body -->
                @if(count($globalsettings) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $globalsettings])
                @endif
            </div>
            <!-- /.box -->
        </div>
        <!-- /.box -->
    </div>
</section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>

@endsection
