@extends('layouts.Admin.adminForm')

@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->

    <section class="content">
        <div class="box">
            <div class="box-body">
                <div class="row">
                {{ Form::model($settingDetail, array('route' => array('global-settings.update', \Crypt::encryptString($settingDetail->id)), 'method' => 'PUT','files' => true,'id'=>'globalsettingForm')) }}
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputName">Title</label>
                            {{ Form::text('title', !empty($settingDetail->title) ? $settingDetail->title : '', array('class'=>'form-control', 'id'=>'title','placeholder' => 'title', 'disabled' => 'true')) }}
                        </div>
                        <div class="form-group">
                            <label for="exampleInputName">Value {{ $settingDetail->value }}</label>
                            {{ Form::textarea('value', null, array('class'=>'form-control required', 'id'=>'value','placeholder' => 'value')) }}
                        </div>
                        <div class="form-group" style="text-align: center">
                            <span>{{ Form::submit('Submit', ['class'=>'btn btn-success']) }}</span>
                            <span style="margin-left: 10px">
                                <a href="{{route('global-settings.index')}}">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </span>
                        </div>
                    </div>
                    {{Form::close()}}
                </div>
            </div>
        </div>
    </section>
</div>
<!-- /.row -->
</section>
</div>
<script>
    var isDataTypeInteger = "{{$settingDetail->datatype == 'integer'}}",
            globalCharscount = "{{ config('constants.GlobalSetting.globalCharscount.maxLength') }}";
</script>
@endsection
