@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            {{ Form::open(array('method' => 'get', 'class' => 'form-horizontal')) }}
                            <div class="form-group margin-bottom-none">
                                <div class="col-sm-6">
                                    {{ Form::text('search', app('request')->input('search'), ['placeholder'=>'search', 'class'=>'form-control']) }}
                                </div>
                                <div class="col-sm-3">
                                    {{ Form::submit('Submit', ['class'=>'btn btn-success']) }}
                                    <a href="{{url('/'.config("admin.constants.ADMIN_ROUTE_NAME").'/error-logs')}}"
                                        class="btn btn-default">Reset</a>
                                </div>
                            </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($errorLogList) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>@sortablelink('description', 'Error')</th>
                                        <th>@sortablelink('level', 'Level')</th>
                                        <th>@sortablelink('user_agent', 'Client Browser')</th>
                                        <th>@sortablelink('ip', 'Ip Address')</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $page = empty(request()->get('page'))?1:request()->get('page');
                                    $srNo = config('admin.constants.AdminPageSize')*($page -1) + 1;
                                    @endphp
                                    @foreach($errorLogList as $errorLog)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td class="wordbreak"><span
                                                class="recommend-gte">{{ !empty($errorLog->description) ? $errorLog->description : '---' }}</span>
                                        </td>
                                        <td>{{ !empty($errorLog->level) ? $errorLog->level : '---' }}</td>
                                        <td class="wordbreak"><span
                                                class="recommend-gte">{{ !empty($errorLog->user_agent) ? $errorLog->user_agent : '---' }}</span>
                                        </td>
                                        <td class="error-box">{{ !empty($errorLog->ip) ? $errorLog->ip : '---' }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    @if(count($errorLogList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $errorLogList])
                    @endif
                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
