@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body">
                        @if(count($emailTemplateList) > 0)
                        <div class="emailtemp_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Sr.No.</th>
                                        <th>Email Type</th>
                                        <th>Subject</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($emailTemplateList as $key => $emailTemplate)
                                    <tr>
                                        <td>{{ ($emailTemplateList->currentpage()-1) * $emailTemplateList->perpage() + $key + 1 }}</td>

                                        <td>{{ $emailTemplate->emailType?$emailTemplate->emailType->name: \config('admin.constants.EmptyNotation') }}</td>

                                        <td>
                                        <a href="{{url($url.'/'.\Crypt::encryptString($emailTemplate->id))}}" class="various"
                                                data-fancybox-type="iframe" title="View">{{ $emailTemplate->subject }}</a>
                                        </td>

                                        <td class="action-btn">
                                        <!-- change status of the resource -->
                                        <span style="float:left; margin:2px 10px;">
                                            <a href="javascript:void(0)" id="{{$emailTemplate->id}}" data="{{\Crypt::encryptString($emailTemplate->id)}}"
                                                baseUrl="{{$adminUrl.'/'.$controllerUri.'/'.\Crypt::encryptString($emailTemplate->id).'/edit'}}"
                                                model="{{ \Crypt::encryptString('email_templates')}}" class="change-status-confirm"
                                                msg="{{__('admin/flash_msg.error.ConfirmChangeStatus')}}">
                                                <span style="cursor:pointer" class="glyphicon {{ ($emailTemplate->status==1)?'glyphicon-ok':'glyphicon-remove' }}"
                                                    aria-hidden="true" title="{{($emailTemplate->status==1)? 'Active' : 'Inactive'}}">
                                                </span>
                                            </a>
                                        </span>

                                        <!-- edit resource -->
                                        <span>
                                            {!! Form::open(['method' => 'GET', 'route' => [$controllerUri.'.edit',
                                            \Crypt::encryptString($emailTemplate->id)]]) !!}
                                            {!! Form::button('', ['type' => 'submit', 'class' => 'actions-btn pull-left
                                            fa fa-edit', 'title' => 'Edit']) !!}
                                            {!! Form::close() !!}
                                        </span>
                                        </td>
                                    </tr>
                                    @endforeach

                                </tbody>

                            </table>
                        </div>
                        @else
                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>
                    <!-- /.box-body -->
                    @if(count($emailTemplateList) > 0)
                    @include('elements.Admin.pagination-link', ['dataList' => $emailTemplateList])
                    @endif
                </div>
                <!-- /.box -->
            </div>
            <!-- /.box -->
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
