@extends('layouts.Admin.adminForm')

@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{$title}} : {{$subTitle}}</h1>
        @include('elements.Admin.breadcrumb')
    </section>

    <section class="content">
        <div class="box">
            <div class="box-body">
                <div class="row">
                    {{ Form::model($emailTemplateDetail, array('route' => array('email-templates.update', \Crypt::encryptString  ($emailTemplateDetail->id)), 'method' => 'PUT','files' => false,'id'=>$formId)) }}

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="exampleInputName">Email Type</label>
                            {{ Form::select('email_type_id', $emailTypes, null, ['class' => 'form-control chosen-select title']) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputName">Subject</label>
                            {{ Form::text('subject', null, array('class'=>'form-control required', 'id'=>'subject','placeholder' => 'subject')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputName">Content</label>
                            {{ Form::textarea('content', null, array('class'=>'form-control required', 'id'=>'content','placeholder' => 'Content')) }}
                        </div>

                        <div class="form-group">
                            <label for="exampleInputEmail1">Status</label>
                            {{Form::select('status',['1' => 'Active', '0' => 'Inactive'], (isset($emailTemplateDetail->status) && is_numeric($emailTemplateDetail->status) ? $emailTemplateDetail->status : ''), ['class'=>'form-control'])}}
                        </div>

                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="col-md-6">
                                    {{ Form::submit('Submit', array('class'=>'btn btn-success pull-right')) }}
                                </div>

                                <div class="col-md-6">
                                    <a href="{{route('email-templates.index')}}">
                                        <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    {{Form::close()}}

                    <div class="col-md-6 right_section pull-right">
                        <b class="hnote">Help Note</b>
                        @if($emailTemplateDetail->email_type_id == '1')
                        <ul>
                            <li><b>{USER_NAME} </b>=> Display username</li>
                            <li><b>{LOGIN_ID} </b> => Display Login Id</li>
                            <li><b>{PASSWORD}</b> => Display Login Id</li>
                            <li><b>{SITE_NAME} </b>=> Display site name</li>
                        </ul>
                        @elseif($emailTemplateDetail->email_type_id == '2')
                        <ul>
                            <li>{USER_NAME} => Display username</li>
                            <li>{SITE_NAME} => Display site name</li>
                            <li>{LINK} => Display link</li>
                        </ul>
                        @elseif($emailTemplateDetail->email_type_id == '3')
                        <ul>
                            <li>{USER_NAME} => Display username</li>
                            <li>{LOGIN_ID} => Display Login Id</li>
                            <li>{PASSWORD} => Display Password</li>
                            <li>{SITE_NAME} => Display site name</li>
                        </ul>
                        @elseif($emailTemplateDetail->email_type_id == '4')
                        <ul>
                            <li>{USER_NAME} => Display username</li>
                            <li>{SITE_NAME} => Display site name</li>
                        </ul>
                        @elseif($emailTemplateDetail->email_type_id == '5')
                        <ul>
                            <li>{USER_NAME} => Display username</li>
                            <li>{OLD_EMAIL} => Display Old Email</li>
                            <li>{NEW_EMAIL} => Display New Email</li>
                            <li>{SITE_NAME} => Display site name</li>
                        </ul>
                        @elseif($emailTemplateDetail->email_type_id == '6')
                        <ul>
                            <li>{USER_NAME} => Display username</li>
                            <li>{FACILITY_NAME} => Display Facility</li>
                            <li>{UUID} => Display UUID</li>
                            <li>{SITE_NAME} => Display site name</li>
                        </ul>
                        @endif
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>
<!-- /.row -->
</section>
<!-- /.content -->
</div>

<script>
let baseURL = "{{\Config('admin.path.BASE_URL')}}";
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}/email-image-upload";
</script>
@endsection