@extends('layouts.Admin.adminPopup')
@section('content')
    <div class="content-wrapper" style="margin-left:0px !important;">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>{{ $title }} : {{ $subTitle }}</h1>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                            </div>
                        </div>

                        <div class="box-body">
                            <div class="new_product_form">
                                <div class="col-sm-6 owntable table-scrollable" style="width:100% !important;">
                                    <table id="example1" class="table table-bordered table-striped">
                                        <tr>
                                            <th scope="row"><?= __('Rider ID') ?></th>
                                            <td>
                                                {{ !empty($userDetail->id) ? $userDetail->id : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('First Name') ?></th>
                                            <td>
                                                {{ !empty($userDetail->user->first_name)? $userDetail->user->first_name: \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Last Name') ?></th>
                                            <td>
                                                {{ !empty($userDetail->user->last_name)? $userDetail->user->last_name: \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Email Id') ?></th>
                                            <td>
                                                {{ !empty($userDetail->user->email) ? $userDetail->user->email : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Phone Number') ?></th>
                                            <td>
                                                {{ !empty($userDetail->user->phone_number)? $userDetail->user->phone_number: \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Age') ?> </th>
                                            <td>
                                                {{ !empty($userDetail->age) ? $userDetail->age : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Bank Name') ?></th>
                                            <td>
                                                {{ !empty($userDetail->bank_name) ? $userDetail->bank_name : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('Account Number') ?></th>
                                            <td>
                                                {{ !empty($userDetail->account_number) ? $userDetail->account_number : \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row"><?= __('ID Proof') ?></th>
                                            <td>
                                                @include('elements.Admin.file-preview' , ['file'=>$userDetail->id_proof])
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Vehicle Information') ?></th>
                                            <td>
                                                @include('elements.Admin.file-preview' ,
                                                ['file'=>$userDetail->vehicle_info])
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Driving License') ?></th>
                                            <td>
                                                @include('elements.Admin.file-preview' ,
                                                ['file'=>$userDetail->driving_license])

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Image') ?></th>
                                            <td>
                                                @php
                                                    $userAvatar = \app\Model\Admin\UserAvatars::where(['user_id' => $userDetail->user_id])->latest();

                                                    $avatarImage = !empty($userAvatar->first()) ? $userAvatar->first()->avatar : null;
                                                @endphp
                                                @include('elements.Admin.file-preview' , ['file'=>$avatarImage])

                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Status') ?></th>
                                            <td>
                                                {{ \config('admin.constants.STATUS')[$userDetail->status] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?= __('Created at') ?></th>
                                            <td>
                                                {{ !empty($userDetail->created_at)? \Carbon\Carbon::parse($userDetail->created_at)->format('m/d/Y'): \config('admin.constants.EmptyNotation') }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
