@extends('layouts.Admin.adminDatagrid')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1> {{ $title }} </h1>
            @include('elements.Admin.breadcrumb')
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header">
                            <div class="col-lg-12 searchBox showhidesearch boxShadow">
                                {{ Form::open(['method' => 'get', 'class' => 'form-horizontal']) }}
                                <div class="form-group margin-bottom-none">
                                    <div class="col-sm-6">
                                        {{ Form::text('search', app('request')->input('search'), ['placeholder' => 'Email / Name / Phone number','class' => 'form-control']) }}
                                    </div>
                                    <div class="col-sm-2">
                                        {{ Form::select('rider_id', $riderList, app('request')->input('rider_id'), ['placeholder' => 'Rider ID','class' => 'form-control select2']) }}
                                    </div>

                                    <div class="col-sm-2">
                                        {{ Form::submit('Submit', ['class' => 'btn btn-success']) }}
                                        <a href="{{ $url }}" class="btn btn-default">Reset</a>
                                    </div>
                                </div>
                                {{ Form::close() }}
                            </div>
                        </div>
                        <div class="box-body">
                            @if (count($userList) > 0)
                                <div class="adminusers_table">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th width="5%">Sr.No.</th>
                                                <th width="15%">Name (Rider ID)</th>
                                                <th width="15%">Email</th>
                                                <th width="15%">Phone Number</th>
                                                <th width="10%">Age</th>
                                                <th width="10%">Image</th>
                                                <th width="15%">Approval Status</th>
                                                <th width="15%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $srNo = $limit * ($page - 1) + 1;
                                            @endphp
                                            @foreach ($userList as $user)

                                                <tr>
                                                    <td>{{ $srNo++ }}</td>
                                                    <td>
                                                        <a href="{{ url($url . '/' . \Crypt::encryptString($user->id)) }}"
                                                            class="various" data-fancybox-type="iframe"
                                                            title="View">{{ $user->user->first_name . ' ' . $user->user->last_name }}
                                                            ({{ $user->id }})
                                                        </a>
                                                    </td>
                                                    <td>{{ !empty($user->user->email) ? $user->user->email : \config('admin.constants.EmptyNotation') }}
                                                    </td>
                                                    <td>{{ !empty($user->user->phone_number) ? $user->user->phone_number : \config('admin.constants.EmptyNotation') }}
                                                    </td>
                                                    <td>{{ !empty($user->age) ? $user->age : \config('admin.constants.EmptyNotation') }}
                                                    </td>



                                                    <td>

                                                        @if (!empty($user->user->profile_image))
                                                            <div class="ImgPopup productimages" style="cursor: pointer"
                                                                href="{{ $user->user->profile_image }}">
                                                                {{ Html::image($user->user->profile_image, '', ['width' => 50, 'height' => 50, 'title' => 'Profile Image']) }}
                                                            </div>

                                                        @else
                                                            <div class="ImgPopup productimages" style="cursor: pointer"
                                                                href="{{ $defaultAvatarUrl }}">
                                                                {{ Html::image($defaultAvatarUrl, '', ['width' => 50, 'height' => 50, 'title' => 'Profile Image']) }}
                                                            </div>
                                                        @endif
                                                    </td>

                                                    <td>
                                                        <span style="float:left; margin:2px 10px;"
                                                            id="approvalStatus{{ $user->id }}">
                                                            @if ($user->is_approved == 1 && $user->status == 1)
                                                                <button type="button" class="btn btn-success btn-sm"
                                                                    title="Approved" disabled="disabled"
                                                                    class="change-status-confirm"
                                                                    style="padding: 2px 20px; margin-bottom: 10px; font-size: 14px;">Approved
                                                                </button>
                                                                <br>

                                                                <a href="javascript:void(0)"
                                                                    data="{{ \Crypt::encryptString($user->id) }}"
                                                                    baseUrl="{{ $adminUrl . '/' . $controllerUri . '/rejectRequestForm/' . \Crypt::encryptString($user->id) }}"
                                                                    model="{{ \Crypt::encryptString($controllerUri) }}"
                                                                    class="change-approve-status"
                                                                    msg="{{ __('admin/flash_msg.error.ConfirmChangeStatus') }}"
                                                                    status="reject">

                                                                    <button type="button"
                                                                        class="btn btn-primary btn-sm buttonload"
                                                                        title="Click to Disapprove Request"
                                                                        style="padding: 2px 10px;">Disapprove</button>
                                                                </a>


                                                            @elseif($user->is_approved == 2 || ($user->is_approved == 1 && $user->status == 0))
                                                                <button type="button" class="btn btn-primary btn-sm"
                                                                    title="Disapproved" disabled="disabled"
                                                                    style="padding: 2px 9px; font-size: 14px; margin-bottom: 10px;">Disapproved</button>
                                                                <br>
                                                                <a href="javascript:void(0)"
                                                                    data="{{ \Crypt::encryptString($user->id) }}"
                                                                    baseUrl="{{ $adminUrl . '/' . $controllerUri . '/requestStatusHandler' }}"
                                                                    model="{{ \Crypt::encryptString($controllerUri) }}"
                                                                    class="change-approve-status"
                                                                    msg="{{ __('admin/flash_msg.error.ConfirmChangeStatus') }}"
                                                                    status="approve">

                                                                    <button type="button"
                                                                        class="btn btn-success btn-sm buttonload"
                                                                        title="Click to Approve Request"
                                                                        style="padding: 2px 16px;">Approve
                                                                        &nbsp;&nbsp;</button>
                                                                </a>
                                                                <!-- <span class="glyphicon glyphicon-remove" title="Request Rejected"></span> -->
                                                            @else
                                                                <a href="javascript:void(0)"
                                                                    data="{{ \Crypt::encryptString($user->id) }}"
                                                                    baseUrl="{{ $adminUrl . '/' . $controllerUri . '/requestStatusHandler' }}"
                                                                    model="{{ \Crypt::encryptString($controllerUri) }}"
                                                                    class="change-approve-status"
                                                                    msg="{{ __('admin/flash_msg.error.ConfirmChangeStatus') }}"
                                                                    status="approve">
                                                                    <button type="button"
                                                                        class="btn btn-success btn-sm buttonload"
                                                                        title="Click to Approve Request"
                                                                        style="padding: 2px 16px;">Approve
                                                                        &nbsp;&nbsp;</button>
                                                                </a>
                                                                <br>
                                                                <br>

                                                                <a href="javascript:void(0)"
                                                                    data="{{ \Crypt::encryptString($user->id) }}"
                                                                    baseUrl="{{ $adminUrl . '/' . $controllerUri . '/rejectRequestForm/' . \Crypt::encryptString($user->id) }}"
                                                                    model="{{ \Crypt::encryptString($controllerUri) }}"
                                                                    class="change-approve-status"
                                                                    msg="{{ __('admin/flash_msg.error.ConfirmChangeStatus') }}"
                                                                    status="reject">
                                                                    <button type="button"
                                                                        class="btn btn-primary btn-sm buttonload"
                                                                        title="Click to Disapprove Request"
                                                                        style="padding: 2px 10px;">Disapprove</button>
                                                                </a>
                                                            @endif

                                                        </span>

                                                    </td>

                                                    <td class="action-btn-permission">
                                                        @include('elements.Admin.action-link-deliveryp', ['row' => $user ])

                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <table class="table">
                                    <tr>
                                        <td colspan="10" class="text-danger text-center error-msg">
                                            {{ config('flash_msg.NoRecordFound') }}</td>
                                    </tr>
                                </table>
                            @endif
                        </div>
                        @if (count($userList) > 0)
                            @include('elements.Admin.pagination-link', ['dataList' => $userList])
                        @endif
                    </div>
                </div>
            </div>
        </section>
        @include('Admin.delivery-persons.reject_request' , ['adminUrl'=>$adminUrl , 'controllerUri'=>$controllerUri])
    </div>
    <script>
        let adminURL = "{{ \Config('admin.path.ADMIN_BASE_URL') }}";
    </script>
@endsection
