@extends('layouts.Admin.adminForm')
@section('content')
    <div class="content-wrapper">
        @include('Admin.flash_message')
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>{{ $title }} : {{ $subTitle }} (Rider ID : {{ $userDetail->delivery_person_id }})</h1>
            @include('elements.Admin.breadcrumb')
        </section>

        <!-- Main content -->
        <section class="content main_box">
            <div class="row">
                <!-- left column -->
                <div class="col-md-12">

                    <!-- general form elements -->
                    <div class="box box-primary">
                        {{ Form::model($userDetail, ['route' => [$controllerUri . '.update', \Crypt::encryptString($userDetail->delivery_person_id)],'method' => 'PUT','novalidate' => 'false','files' => true,'id' => $formId]) }}

                        <div class="box-body form_box">
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">First Name</label>
                                        {{ Form::text('first_name', $userDetail->first_name, ['class' => 'form-control required','id' => 'firstName','placeholder' => 'First Name','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Last Name</label>
                                        {{ Form::text('last_name', $userDetail->last_name, ['class' => 'form-control required','id' => 'lastName','placeholder' => 'Last Name','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>
                            </div>

                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Email</label>
                                        {{ Form::email('email', $userDetail->email, ['class' => 'form-control required customemail','id' => 'email','placeholder' => 'Email','onchange' => 'return trim(this)','disabled' => 'disabled']) }}
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1" class="col-md-12">Phone Number</label>
                                        <div class="col-md-3">
                                            <input value="+233" class="form-control" type="text" disabled="">
                                        </div>
                                        <div class="col-md-9">

                                            {{ Form::text('phone_number', !empty($userDetail->phone_number) ? $userDetail->phone_number : '', ['class' => 'form-control','id' => 'phone_number','placeholder' => 'Phone number: eg; 9876543210','onchange' => 'return trim(this)']) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row input_row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Age</label>
                                        {{ Form::text('age', !empty($userDetail->age) ? $userDetail->age : '', ['class' => 'form-control','id' => 'phone_number','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Bank Name</label>
                                        {{ Form::text('bank_name', !empty($userDetail->bank_name) ? $userDetail->bank_name : '', ['class' => 'form-control','id' => 'bank_name','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>
                            </div>

                            <div class="row input_row">




                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Account Number</label>
                                        {{ Form::text('account_number', !empty($userDetail->account_number) ? $userDetail->account_number : '', ['class' => 'form-control','id' => 'account_number','onchange' => 'return trim(this)']) }}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Status</label>
                                        {{ Form::select('status',[1 => 'Active', 0 => 'Inactive'],isset($userDetail->status) && is_numeric($userDetail->status) ? $userDetail->status : 0,['class' => 'form-control']) }}
                                    </div>
                                </div>


                            </div>




                            <br>
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="image-upload">
                                                <div class="file-label" style="text-align: left">Upload Vehicle Info
                                                </div>
                                                {{ Form::file('vehicle_info', ['id' => 'vehicle_info']) }}
                                            </div>
                                        </div>

                                        @include('elements.Admin.file-preview' , ['file'=>$userDetail->vehicle_info])
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="image-upload">
                                                <div class="file-label" style="text-align: left">Upload Driving License
                                                </div>
                                                {{ Form::file('driving_license', ['id' => 'driving_license']) }}
                                            </div>
                                        </div>
                                        @include('elements.Admin.file-preview' , ['file'=>$userDetail->driving_license])
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="row input_row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="image-upload">
                                                <div class="file-label" style="text-align: left">Upload Id Proof</div>
                                                {{ Form::file('id_proof', ['id' => 'id_proof']) }}
                                            </div>
                                        </div>
                                        @include('elements.Admin.file-preview' , ['file'=>$userDetail->id_proof])
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="image-upload">
                                                <div class="file-label" style="text-align: left">Upload Image</div>
                                                {{ Form::file('avatar', ['id' => 'avatar']) }}
                                            </div>
                                        </div>

                                        @php

                                            $avatarImage = !empty($userDetail->profile_image) ? $userDetail->profile_image : null;
                                        @endphp
                                        @include('elements.Admin.file-preview' , ['file'=>$avatarImage])
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="box-footer row">
                            <div class="col-md-6">
                                {{ Form::submit('Submit', ['class' => 'btn btn-success pull-right']) }}
                            </div>
                            <div class="col-md-6">
                                <a href="{{ route('delivery-persons.index') }}">
                                    <button class="btn cancelbtn btn-default" type="button">Cancel</button>
                                </a>
                            </div>
                        </div>
                        {{ Form::close() }}
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
@endsection
