@extends('layouts.Admin.adminDatagrid')
@section('content')
<div class="content-wrapper">
    @include('Admin.flash_message')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1> {{$title}} </h1>
        @include('elements.Admin.breadcrumb')
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-header">
                        <div class="col-lg-12 searchBox showhidesearch boxShadow">

                        </div>
                    </div>
                    <div class="box-body">
                        @if(count($DeliveryChargeSetting) > 0)
                        <div class="adminusers_table">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="10%">Sr.No.</th>
                                        <th width="15%">Title</th>
                                        <th width="15%">Value</th>
                                        <th width="15%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                    $srNo = $limit*($page -1) + 1;
                                    @endphp 
                                    @foreach($DeliveryChargeSetting as $DeliveryCharge)
                                    <tr>
                                        <td>{{ $srNo++ }}</td>
                                        <td>{{ $DeliveryCharge->name }}</td>
                                        <td>{{ $DeliveryCharge->value . ' '.$DeliveryCharge->symbal}}
                                        </td>
                                         <td class="action-btn">
                                             @include('elements.Admin.delivery-charge.action-link-delivery', ['row' => $DeliveryCharge])
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @else

                        <table class="table">
                            <tr>
                                <td colspan="10" class="text-danger text-center error-msg">
                                    {{config('flash_msg.NoRecordFound')}}</td>
                            </tr>
                        </table>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>
<script>
let adminURL = "{{\Config('admin.path.ADMIN_BASE_URL')}}";
</script>
@endsection
